/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

@Mojo(name="archive-repository", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public final class ArchiveRepositoryMojo
extends AbstractRepositoryMojo {
    @Component(role=Archiver.class, hint="zip")
    private Archiver inflater;
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Parameter(defaultValue="false")
    private boolean skipArchive;
    @Component
    private FileLockService fileLockService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipArchive) {
            return;
        }
        File repositoryLocation = this.getAssemblyRepositoryLocation();
        File destFile = this.getBuildDirectory().getChild(this.finalName + ".zip");
        try (Closeable repoLock = this.fileLockService.lockVirtually(repositoryLocation);
             Closeable destLock = this.fileLockService.lockVirtually(destFile);){
            this.inflater.addFileSet((FileSet)DefaultFileSet.fileSet((File)repositoryLocation).prefixed(""));
            this.inflater.setDestFile(destFile);
            this.inflater.createArchive();
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException("Error packing p2 repository", (Exception)e);
        }
        this.getProject().getArtifact().setFile(destFile);
    }
}

