/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractVersionMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="project.packaging", required=true, readonly=true)
    protected String packaging;
    @Component(role=TychoProject.class)
    protected Map<String, TychoProject> projectTypes;
    @Component
    BuildContext buildContext;

    protected String getOSGiVersion() {
        ArtifactKey osgiArtifact = this.getOSGiArtifact();
        return osgiArtifact != null ? osgiArtifact.getVersion() : null;
    }

    protected String getOSGiId() {
        ArtifactKey osgiArtifact = this.getOSGiArtifact();
        return osgiArtifact != null ? osgiArtifact.getId() : null;
    }

    private ArtifactKey getOSGiArtifact() {
        TychoProject projectType = this.projectTypes.get(this.packaging);
        if (projectType == null) {
            return null;
        }
        return projectType.getArtifactKey(DefaultReactorProject.adapt((MavenProject)this.project));
    }

    protected File getOSGiMetadataFile() {
        if (this.project == null) {
            return null;
        }
        return new File(this.project.getBasedir(), this.getOSGiMetadataFileName());
    }

    protected String getOSGiMetadataFileName() {
        String packaging = this.project.getPackaging();
        if ("eclipse-plugin".equals(packaging) || "eclipse-test-plugin".equals(packaging)) {
            return "META-INF/MANIFEST.MF";
        }
        if ("eclipse-feature".equals(packaging)) {
            return "feature.xml";
        }
        if ("eclipse-repository".equals(packaging)) {
            return this.project.getArtifactId();
        }
        if ("p2-installable-unit".equals(packaging)) {
            return "p2iu.xml";
        }
        return "<unknown packaging=" + packaging + ">";
    }
}

