/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.buildversion;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.DependencyArtifacts;
import org.eclipse.tycho.build.BuildTimestampProvider;
import org.eclipse.tycho.buildversion.BuildQualifierMojo;
import org.eclipse.tycho.buildversion.TimestampFinder;
import org.eclipse.tycho.core.BundleProject;
import org.eclipse.tycho.core.TychoProjectManager;
import org.eclipse.tycho.helper.PluginConfigurationHelper;

@Component(role=BuildTimestampProvider.class, hint="fragment-host")
public class FragmentHostBuildTimestampProvider
implements BuildTimestampProvider {
    static final String ROLE_HINT = "fragment-host";
    @Requirement
    private TychoProjectManager projectManager;
    @Requirement
    private Logger logger;
    @Requirement
    private TimestampFinder timestampFinder;
    @Requirement
    private PluginConfigurationHelper configurationHelper;

    public Date getTimestamp(MavenSession session, MavenProject project, MojoExecution execution) {
        BundleProject bundle;
        String fragmentHost;
        Object t;
        Optional tychoProject = this.projectManager.getTychoProject(project);
        Exception exception = null;
        if (tychoProject.isPresent() && (t = tychoProject.get()) instanceof BundleProject && (fragmentHost = (bundle = (BundleProject)t).getManifestValue("Fragment-Host", project)) != null) {
            try {
                ManifestElement[] header;
                for (ManifestElement element : header = ManifestElement.parseHeader((String)"Fragment-Host", (String)fragmentHost)) {
                    DependencyArtifacts dependencyArtifacts = (DependencyArtifacts)this.projectManager.getDependencyArtifacts(project).get();
                    ArtifactDescriptor descriptor = dependencyArtifacts.getArtifact("eclipse-plugin", element.getValue(), element.getAttribute("bundle-version"));
                    if (descriptor == null) continue;
                    PluginConfigurationHelper.Configuration configuration = this.configurationHelper.getConfiguration();
                    Optional formatString = configuration.getString("format");
                    SimpleDateFormat format = formatString.map(SimpleDateFormat::new).orElseGet(() -> new SimpleDateFormat("yyyyMMddHHmm"));
                    format.setTimeZone(BuildQualifierMojo.TIME_ZONE);
                    Date date = this.timestampFinder.findByDescriptor(descriptor, format);
                    if (date == null) continue;
                    return date;
                }
            }
            catch (Exception e) {
                exception = e;
            }
        }
        this.logger.warn("Can't determine fragment host, fallback to default.", exception);
        return session.getStartTime();
    }

    public void setQuiet(boolean quiet) {
    }
}

