/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.helper;

import java.util.Optional;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MojoExecutionListener.class, hint="helper")
public class MojoExecutionHelper
implements MojoExecutionListener {
    private static final ThreadLocal<MojoExecutionEvent> EVENT = new ThreadLocal();

    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        EVENT.set(event);
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
        EVENT.remove();
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
        EVENT.remove();
    }

    public static Optional<MojoExecution> getExecution() {
        MojoExecutionEvent executionEvent = EVENT.get();
        if (executionEvent == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(executionEvent.getExecution());
    }
}

