/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.provider.impl;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.ClasspathEntry;
import org.eclipse.tycho.surefire.provider.spi.TestFrameworkProvider;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public abstract class AbstractJUnitProvider
implements TestFrameworkProvider {
    @Override
    public String getType() {
        return "junit";
    }

    @Override
    public boolean isEnabled(MavenProject project, List<ClasspathEntry> testBundleClassPath, Properties surefireProperties) {
        boolean classpath = this.containsJunitInClasspath(testBundleClassPath);
        if (!classpath && project != null) {
            return this.containsJunitInDependencies(project);
        }
        return classpath;
    }

    protected boolean containsJunitInDependencies(MavenProject project) {
        Set<String> junitBundleNames = this.getJUnitBundleNames();
        VersionRange range = this.getJUnitVersionRange();
        for (Artifact artifact : project.getArtifacts()) {
            if (!"test".equals(artifact.getScope()) || !junitBundleNames.contains(artifact.getArtifactId())) continue;
            try {
                Version version = Version.parseVersion((String)artifact.getVersion());
                if (!range.includes(version)) continue;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return false;
    }

    protected boolean containsJunitInClasspath(List<ClasspathEntry> testBundleClassPath) {
        Set<String> junitBundleNames = this.getJUnitBundleNames();
        VersionRange range = this.getJUnitVersionRange();
        for (ClasspathEntry classpathEntry : testBundleClassPath) {
            Version version;
            ArtifactKey artifactKey = classpathEntry.getArtifactKey();
            if (!junitBundleNames.contains(artifactKey.getId()) || !range.includes(version = Version.parseVersion((String)artifactKey.getVersion()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Properties getProviderSpecificProperties() {
        return new Properties();
    }

    protected abstract VersionRange getJUnitVersionRange();

    protected abstract Set<String> getJUnitBundleNames();
}

