/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.Category;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.model.UpdateSite;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.manipulation.AbstractMetadataManipulator;
import org.eclipse.tycho.versions.manipulation.SiteXmlManipulator;
import org.eclipse.tycho.versions.pom.PomFile;

@Component(role=MetadataManipulator.class, hint="eclipse-repository")
public class CategoryXmlManipulator
extends AbstractMetadataManipulator {
    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isEclipseRepository(project)) {
            for (VersionChange versionChange : versionChangeContext.getVersionChanges()) {
                if (this.isFeature(versionChange.getProject().getPackaging())) {
                    this.updateFeatureReferences(versionChange, project);
                    continue;
                }
                if (!this.isBundle(versionChange.getProject())) continue;
                this.updatePluginReferences(versionChange, project);
            }
        }
    }

    private void updateFeatureReferences(VersionChange featureVersionChange, ProjectMetadata project) {
        Category categoryXml = this.getCategoryXml(project);
        if (categoryXml == null) {
            return;
        }
        for (UpdateSite.SiteFeatureRef feature : categoryXml.getFeatures()) {
            if (!featureVersionChange.getArtifactId().equals(feature.getId()) || !featureVersionChange.getVersion().equals(feature.getVersion())) continue;
            this.logger.info("  category.xml//site/feature[@id=" + feature.getId() + "]/@version: " + featureVersionChange.getVersion() + " => " + featureVersionChange.getNewVersion());
            feature.setVersion(featureVersionChange.getNewVersion());
            String oldUrl = feature.getUrl();
            if (oldUrl == null) continue;
            String newUrl = SiteXmlManipulator.rewriteFeatureUrl(oldUrl, featureVersionChange);
            this.logger.info("  category.xml//site/feature[@id=" + feature.getId() + "]/@url: " + oldUrl + " => " + newUrl);
            feature.setUrl(newUrl);
        }
    }

    private void updatePluginReferences(VersionChange pluginVersionChange, ProjectMetadata project) {
        Category categoryXml = this.getCategoryXml(project);
        if (categoryXml == null) {
            return;
        }
        for (PluginRef plugin : categoryXml.getPlugins()) {
            if (!pluginVersionChange.getArtifactId().equals(plugin.getId()) || !pluginVersionChange.getVersion().equals(plugin.getVersion())) continue;
            this.logger.info("  category.xml//site/bundle[@id=" + plugin.getId() + "]/@version: " + pluginVersionChange.getVersion() + " => " + pluginVersionChange.getNewVersion());
            plugin.setVersion(pluginVersionChange.getNewVersion());
        }
    }

    private Category getCategoryXml(ProjectMetadata project) {
        Category categoryXml = project.getMetadata(Category.class);
        if (categoryXml == null) {
            File file = new File(project.getBasedir(), "category.xml");
            if (!file.isFile()) {
                return null;
            }
            try {
                categoryXml = Category.read((File)file);
                project.putMetadata(categoryXml);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not read categories from " + file, e);
            }
        }
        return categoryXml;
    }

    private boolean isEclipseRepository(ProjectMetadata project) {
        PomFile pom = project.getMetadata(PomFile.class);
        return "eclipse-repository".equals(pom.getPackaging());
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        File basedir = project.getBasedir();
        Category categoryXml = project.getMetadata(Category.class);
        if (categoryXml != null) {
            Category.write((Category)categoryXml, (File)new File(basedir, "category.xml"));
        }
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        return null;
    }
}

