/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.versions.manipulation;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.tycho.model.ProductConfiguration;
import org.eclipse.tycho.versions.engine.MetadataManipulator;
import org.eclipse.tycho.versions.engine.ProductConfigurations;
import org.eclipse.tycho.versions.engine.ProjectMetadata;
import org.eclipse.tycho.versions.engine.VersionChange;
import org.eclipse.tycho.versions.engine.VersionChangesDescriptor;
import org.eclipse.tycho.versions.engine.Versions;
import org.eclipse.tycho.versions.manipulation.ProductFileManipulator;
import org.eclipse.tycho.versions.pom.PomFile;

@Component(role=MetadataManipulator.class, hint="eclipse-repository-products")
public class EclipseRepositoryProductFileManipulator
extends ProductFileManipulator {
    @Override
    public void applyChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (!this.isEclipseRepository(project)) {
            return;
        }
        for (VersionChange change : versionChangeContext.getVersionChanges()) {
            for (Map.Entry<File, ProductConfiguration> entry : this.getProductConfigurations(project).entrySet()) {
                this.applyChangeToProduct(project, entry.getValue(), entry.getKey().getName(), change);
            }
        }
    }

    @Override
    public Collection<String> validateChanges(ProjectMetadata project, VersionChangesDescriptor versionChangeContext) {
        if (this.isEclipseRepository(project)) {
            for (VersionChange change : versionChangeContext.getVersionChanges()) {
                ArrayList<String> errors = new ArrayList<String>();
                for (Map.Entry<File, ProductConfiguration> entry : this.getProductConfigurations(project).entrySet()) {
                    String error;
                    if (!this.isSameProject(project, change.getProject()) || !change.getVersion().equals(entry.getValue().getVersion()) || (error = Versions.validateOsgiVersion(change.getNewVersion(), entry.getKey())) == null) continue;
                    errors.add(error);
                }
                if (errors.isEmpty()) continue;
                return errors;
            }
        }
        return null;
    }

    private boolean isEclipseRepository(ProjectMetadata project) {
        return "eclipse-repository".equals(project.getMetadata(PomFile.class).getPackaging());
    }

    @Override
    public void writeMetadata(ProjectMetadata project) throws IOException {
        ProductConfigurations products = project.getMetadata(ProductConfigurations.class);
        if (products != null) {
            for (Map.Entry<File, ProductConfiguration> entry : products.getProductConfigurations().entrySet()) {
                ProductConfiguration.write((ProductConfiguration)entry.getValue(), (File)entry.getKey());
            }
        }
    }

    private Map<File, ProductConfiguration> getProductConfigurations(ProjectMetadata project) {
        ProductConfigurations products = project.getMetadata(ProductConfigurations.class);
        if (products == null) {
            products = new ProductConfigurations();
            File[] productFiles = project.getBasedir().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".product");
                }
            });
            if (productFiles != null) {
                for (File productFile : productFiles) {
                    try {
                        products.addProductConfiguration(productFile, ProductConfiguration.read((File)productFile));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Could not read product configuration file " + productFile, e);
                    }
                }
            }
            project.putMetadata(products);
        }
        return products.getProductConfigurations();
    }
}

