/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestConverters;
import org.elasticsearch.client.license.DeleteLicenseRequest;
import org.elasticsearch.client.license.GetLicenseRequest;
import org.elasticsearch.client.license.PutLicenseRequest;
import org.elasticsearch.client.license.StartBasicRequest;
import org.elasticsearch.client.license.StartTrialRequest;

final class LicenseRequestConverters {
    private LicenseRequestConverters() {
    }

    static Request putLicense(PutLicenseRequest putLicenseRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_license").build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(putLicenseRequest.timeout());
        parameters.withMasterTimeout(putLicenseRequest.masterNodeTimeout());
        if (putLicenseRequest.isAcknowledge()) {
            parameters.putParam("acknowledge", "true");
        }
        request.setJsonEntity(putLicenseRequest.getLicenseDefinition());
        return request;
    }

    static Request getLicense(GetLicenseRequest getLicenseRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_license").build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withLocal(getLicenseRequest.isLocal());
        return request;
    }

    static Request deleteLicense(DeleteLicenseRequest deleteLicenseRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_license").build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(deleteLicenseRequest.timeout());
        parameters.withMasterTimeout(deleteLicenseRequest.masterNodeTimeout());
        return request;
    }

    static Request startTrial(StartTrialRequest startTrialRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_license", "start_trial").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.putParam("acknowledge", Boolean.toString(startTrialRequest.isAcknowledge()));
        if (startTrialRequest.getLicenseType() != null) {
            parameters.putParam("type", startTrialRequest.getLicenseType());
        }
        return request;
    }

    static Request startBasic(StartBasicRequest startBasicRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_license", "start_basic").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(startBasicRequest.timeout());
        parameters.withMasterTimeout(startBasicRequest.masterNodeTimeout());
        if (startBasicRequest.isAcknowledge()) {
            parameters.putParam("acknowledge", "true");
        }
        return request;
    }

    static Request getLicenseTrialStatus() {
        return new Request("GET", "/_license/trial_status");
    }

    static Request getLicenseBasicStatus() {
        return new Request("GET", "/_license/basic_status");
    }
}

