/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core.internal.provider;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import org.elasticsearch.core.internal.provider.EmbeddedImplClassLoader;
import org.elasticsearch.core.internal.provider.InMemoryModuleFinder;

public final class ProviderLocator<T>
implements Supplier<T> {
    private final String providerName;
    private final Class<T> providerType;
    private final String providerModuleName;
    private final ClassLoader parentLoader;
    private final Set<String> missingModules;
    private final boolean loadAsProviderModule;

    static <P> Class<P> checkUses(Class<P> providerType) {
        Module caller = providerType.getModule();
        if (caller.isNamed()) {
            if (!caller.getDescriptor().uses().stream().anyMatch(providerType.getName()::equals)) {
                throw new ServiceConfigurationError(String.format(Locale.ROOT, "%s: module does not declare uses %s", caller, providerType));
            }
        }
        return providerType;
    }

    public ProviderLocator(String providerName, Class<T> providerType, String providerModuleName, Set<String> missingModules) {
        this(providerName, ProviderLocator.checkUses(providerType), ProviderLocator.class.getClassLoader(), providerModuleName, missingModules, ProviderLocator.class.getModule().isNamed());
    }

    ProviderLocator(String providerName, Class<T> providerType, ClassLoader parentLoader, String providerModuleName, Set<String> missingModules, boolean loadAsProviderModule) {
        Objects.requireNonNull(providerName);
        Objects.requireNonNull(providerType);
        Objects.requireNonNull(parentLoader);
        Objects.requireNonNull(providerModuleName);
        Objects.requireNonNull(missingModules);
        this.providerName = providerName;
        this.providerType = providerType;
        this.providerModuleName = providerModuleName;
        this.parentLoader = parentLoader;
        this.missingModules = missingModules;
        this.loadAsProviderModule = loadAsProviderModule;
    }

    @Override
    public T get() {
        try {
            PrivilegedExceptionAction<Object> pa = this::load;
            return (T)AccessController.doPrivileged(pa);
        }
        catch (PrivilegedActionException e) {
            throw new UncheckedIOException((IOException)e.getCause());
        }
    }

    private T load() throws IOException {
        EmbeddedImplClassLoader loader = EmbeddedImplClassLoader.getInstance(this.parentLoader, this.providerName);
        if (this.loadAsProviderModule) {
            return this.loadAsModule(loader);
        }
        return this.loadAsNonModule(loader);
    }

    private T loadAsNonModule(EmbeddedImplClassLoader loader) {
        ServiceLoader<T> sl = ServiceLoader.load(this.providerType, loader);
        return sl.findFirst().orElseThrow(ProviderLocator.newIllegalStateException(this.providerName));
    }

    private T loadAsModule(EmbeddedImplClassLoader loader) throws IOException {
        ProviderLocator.class.getModule().addUses(this.providerType);
        InMemoryModuleFinder moduleFinder = loader.moduleFinder(this.missingModules);
        assert (moduleFinder.find(this.providerModuleName).isPresent());
        ModuleLayer parentLayer = ModuleLayer.boot();
        Configuration cf = parentLayer.configuration().resolve(ModuleFinder.of(new Path[0]), moduleFinder, Set.of(this.providerModuleName));
        ModuleLayer layer = parentLayer.defineModules(cf, nm -> loader);
        ServiceLoader<T> sl = ServiceLoader.load(layer, this.providerType);
        return sl.findFirst().orElseThrow(ProviderLocator.newIllegalStateException(this.providerName));
    }

    static Supplier<IllegalStateException> newIllegalStateException(String providerName) {
        return () -> new IllegalStateException(String.format(Locale.ROOT, "cannot locate %s provider", providerName));
    }
}

