/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.mapper.attachments;

import java.io.ByteArrayInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ReflectPermission;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.PropertyPermission;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.epub.EpubParser;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.iwork.IWorkPackageParser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OldExcelParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.odf.OpenDocumentParser;
import org.apache.tika.parser.pdf.PDFParser;
import org.apache.tika.parser.rtf.RTFParser;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.parser.xml.DcXMLParser;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;

final class TikaImpl {
    private static final Parser[] PARSERS = new Parser[]{new HtmlParser(), new RTFParser(), new PDFParser(), new TXTParser(), new OfficeParser(), new OldExcelParser(), new OOXMLParser(), new OpenDocumentParser(), new IWorkPackageParser(), new DcXMLParser(), new EpubParser()};
    private static final AutoDetectParser PARSER_INSTANCE = new AutoDetectParser(PARSERS);
    private static final Tika TIKA_INSTANCE = new Tika(PARSER_INSTANCE.getDetector(), (Parser)PARSER_INSTANCE);
    private static final AccessControlContext RESTRICTED_CONTEXT = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, TikaImpl.getRestrictedPermissions())});

    TikaImpl() {
    }

    static String parse(final byte[] content, final Metadata metadata, final int limit) throws TikaException, IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws TikaException, IOException {
                    return TIKA_INSTANCE.parseToString((InputStream)new ByteArrayInputStream(content), metadata, limit);
                }
            }, RESTRICTED_CONTEXT);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TikaException) {
                throw (TikaException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new AssertionError((Object)cause);
        }
    }

    static PermissionCollection getRestrictedPermissions() {
        Permissions perms = new Permissions();
        perms.add(new PropertyPermission("*", "read"));
        perms.add(new RuntimePermission("getenv.TIKA_CONFIG"));
        TikaImpl.addReadPermissions(perms, JarHell.parseClassPath());
        if (TikaImpl.class.getClassLoader() instanceof URLClassLoader) {
            TikaImpl.addReadPermissions(perms, ((URLClassLoader)TikaImpl.class.getClassLoader()).getURLs());
        }
        perms.add(new FilePermission(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "-", "read,readlink,write,delete"));
        perms.add(new SecurityPermission("putProviderProperty.BC"));
        perms.add(new SecurityPermission("insertProvider"));
        perms.add(new ReflectPermission("suppressAccessChecks"));
        perms.add(new RuntimePermission("getClassLoader"));
        perms.setReadOnly();
        return perms;
    }

    @SuppressForbidden(reason="adds access to jar resources")
    static void addReadPermissions(Permissions perms, URL[] resources) {
        try {
            for (URL url : resources) {
                Path path = PathUtils.get((URI)url.toURI());
                perms.add(new FilePermission(path.toString(), "read,readlink"));
                perms.add(new FilePermission(path.toString() + System.getProperty("file.separator") + "-", "read,readlink"));
            }
        }
        catch (URISyntaxException bogus) {
            throw new RuntimeException(bogus);
        }
    }
}

