/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.assured;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.everrest.assured.JettyHttpServer;
import org.everrest.assured.TestResourceFactory;
import org.everrest.core.Filter;
import org.everrest.core.ObjectFactory;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

public class EverrestJetty
implements ITestListener {
    public static final String JETTY_PORT = "jetty-port";
    private static final String JETTY_SERVER = "jetty-server";
    private JettyHttpServer httpServer;

    public void onStart(ITestContext context) {
        ITestNGMethod[] allTestMethods = context.getAllTestMethods();
        if (allTestMethods == null) {
            return;
        }
        List<ObjectFactory<AbstractResourceDescriptor>> factories = this.getResourcesFactories(allTestMethods);
        if (factories.size() > 0) {
            this.httpServer = new JettyHttpServer();
            context.setAttribute(JETTY_PORT, (Object)this.httpServer.getPort());
            context.setAttribute(JETTY_SERVER, (Object)this.httpServer);
            this.httpServer.start();
            this.httpServer.setFactories(factories);
        }
    }

    public void onFinish(ITestContext context) {
        JettyHttpServer httpServer = (JettyHttpServer)context.getAttribute(JETTY_SERVER);
        if (httpServer != null) {
            httpServer.stop();
        }
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
    }

    public void onTestFailure(ITestResult result) {
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    private List<ObjectFactory<AbstractResourceDescriptor>> getResourcesFactories(ITestNGMethod[] testMethods) {
        ArrayList<ObjectFactory<AbstractResourceDescriptor>> factories = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
        for (ITestNGMethod testMethod : testMethods) {
            Field[] fields;
            Object instance = testMethod.getInstance();
            if (!this.hasEverrestJettyListenerTestHierarchy(instance.getClass())) continue;
            for (Field field : fields = instance.getClass().getDeclaredFields()) {
                if (!this.isRestResource(field.getType())) continue;
                factories.add(new TestResourceFactory(field.getType(), instance, field));
            }
        }
        return factories;
    }

    private boolean isRestResource(Class<? extends Object> resourceClass) {
        return resourceClass.isAnnotationPresent(Path.class) || resourceClass.isAnnotationPresent(Provider.class) || resourceClass.isAnnotationPresent(Filter.class);
    }

    private boolean hasEverrestJettyListenerTestHierarchy(Class<?> testClass) {
        for (Class<?> clazz = testClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!this.hasEverrestJettyListener(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEverrestJettyListener(Class<?> clazz) {
        Listeners listeners = clazz.getAnnotation(Listeners.class);
        if (listeners == null) {
            return false;
        }
        for (Class listenerClass : listeners.value()) {
            if (!EverrestJetty.class.isAssignableFrom(listenerClass)) continue;
            return true;
        }
        return false;
    }
}

