/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.assured;

import java.lang.reflect.Field;
import org.everrest.core.ApplicationContext;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.ObjectFactory;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResourceFactory
implements ObjectFactory<AbstractResourceDescriptor> {
    private static final Logger LOG = LoggerFactory.getLogger(TestResourceFactory.class);
    private final Object testParent;
    private final Field resourceField;
    private final Class<?> resourceClass;

    public TestResourceFactory(Class<?> resourceClass, Object testParent, Field resourceField) {
        this.resourceClass = resourceClass;
        this.testParent = testParent;
        this.resourceField = resourceField;
    }

    public Object getInstance(ApplicationContext context) {
        try {
            this.resourceField.setAccessible(true);
            return this.resourceField.get(this.testParent);
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public AbstractResourceDescriptor getObjectModel() {
        return new AbstractResourceDescriptorImpl(this.resourceClass, ComponentLifecycleScope.PER_REQUEST);
    }
}

