/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.File;
import java.io.IOException;

public final class FileCollector {
    private final File store;

    public static FileCollector getInstance() {
        return FileCollectorHolder.INSTANCE;
    }

    private FileCollector(String pathname) {
        this.store = new File(pathname);
        if (!this.store.exists()) {
            this.store.mkdirs();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FileCollector.this.clean();
            }
        });
    }

    public void clean() {
        for (File file : this.store.listFiles()) {
            this.delete(file);
        }
    }

    public File createFile(String fileName) throws IOException {
        return new File(this.store, fileName);
    }

    public File createFile() throws IOException {
        return File.createTempFile("jaxrs", ".tmp", this.store);
    }

    public File getStore() {
        return this.store;
    }

    private void delete(File file) {
        File[] children;
        if (file.isDirectory() && (children = file.listFiles()).length > 0) {
            for (File ch : children) {
                this.delete(ch);
            }
        }
        file.delete();
    }

    private static class FileCollectorHolder {
        private static final FileCollector INSTANCE = new FileCollector(System.getProperty("java.io.tmpdir") + File.separator + "ws_jaxrs");

        private FileCollectorHolder() {
        }
    }
}

