/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import javax.ws.rs.Path;
import org.everrest.core.BaseObjectModel;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.impl.resource.PathValue;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.uri.UriPattern;

public class FilterDescriptorImpl
extends BaseObjectModel
implements FilterDescriptor {
    private final PathValue path;
    private final UriPattern uriPattern;

    public FilterDescriptorImpl(Class<?> filterClass, ComponentLifecycleScope scope) {
        super(filterClass, scope);
        Path p = filterClass.getAnnotation(Path.class);
        if (p != null) {
            this.path = new PathValue(p.value());
            this.uriPattern = new UriPattern(p.value());
        } else {
            this.path = null;
            this.uriPattern = null;
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitFilterDescriptor(this);
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ FilterDescriptorImpl: ");
        sb.append("path: " + this.getPathValue() + "; ").append("filter class: " + this.getObjectClass() + "; ").append(this.getConstructorDescriptors() + "; ").append(this.getFieldInjectors()).append(" ]");
        return sb.toString();
    }
}

