/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import java.text.ParseException;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.everrest.core.header.AbstractHeaderDelegate;
import org.everrest.core.impl.header.HeaderHelper;
import org.everrest.core.impl.header.HeaderParameterParser;

public class MediaTypeHeaderDelegate
extends AbstractHeaderDelegate<MediaType> {
    @Override
    public Class<MediaType> support() {
        return MediaType.class;
    }

    public MediaType fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        try {
            int p = header.indexOf(47);
            int col = header.indexOf(59);
            String type = null;
            String subType = null;
            if (p < 0 && col < 0) {
                return new MediaType(header, null);
            }
            if (p > 0 && col < 0) {
                return new MediaType(HeaderHelper.removeWhitespaces(header.substring(0, p)), HeaderHelper.removeWhitespaces(header.substring(p + 1)));
            }
            if (p < 0 && col > 0) {
                type = HeaderHelper.removeWhitespaces(header.substring(0, col));
            } else {
                type = HeaderHelper.removeWhitespaces(header.substring(0, p));
                subType = header.substring(p + 1, col);
            }
            Map<String, String> m = new HeaderParameterParser().parse(header);
            return new MediaType(type, subType, m);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString(MediaType mime) {
        StringBuilder sb = new StringBuilder();
        sb.append(mime.getType()).append('/').append(mime.getSubtype());
        for (Map.Entry entry : mime.getParameters().entrySet()) {
            sb.append(';').append((String)entry.getKey()).append('=');
            HeaderHelper.appendWithQuote(sb, (String)entry.getValue());
        }
        return sb.toString();
    }
}

