/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.method.filter;

import java.lang.annotation.Annotation;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.Filter;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.resource.GenericMethodResource;

@Filter
public class SecurityConstraint
implements MethodInvokerFilter {
    @Override
    public void accept(GenericMethodResource method) throws WebApplicationException {
        SecurityContext security = ApplicationContextImpl.getCurrent().getSecurityContext();
        this.checkSecurityConstraint(this.getSecurityAnnotation(method), security);
    }

    private void checkSecurityConstraint(Annotation sa, SecurityContext security) {
        if (sa != null) {
            Class<? extends Annotation> saclass = sa.annotationType();
            boolean allowed = false;
            if (saclass == PermitAll.class) {
                allowed = true;
            } else if (saclass == RolesAllowed.class) {
                for (String role : ((RolesAllowed)sa).value()) {
                    if (!security.isUserInRole(role)) continue;
                    allowed = true;
                    break;
                }
            } else if (saclass == DenyAll.class) {
                // empty if block
            }
            if (!allowed) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User not authorized to call this method.").type("text/plain").build());
            }
        }
    }

    private Annotation getSecurityAnnotation(GenericMethodResource method) {
        for (Annotation a : method.getAnnotations()) {
            Class<? extends Annotation> aclass = a.annotationType();
            if (aclass != PermitAll.class && aclass != DenyAll.class && aclass != RolesAllowed.class) continue;
            return a;
        }
        return null;
    }
}

