/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

@Provider
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
@Produces(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
public class JAXBContextResolver
implements ContextResolver<JAXBContextResolver> {
    private final ConcurrentHashMap<Class, JAXBContext> jaxbContexts = new ConcurrentHashMap();

    public JAXBContextResolver getContext(Class<?> type) {
        return this;
    }

    public JAXBContext getJAXBContext(Class<?> clazz) throws JAXBException {
        JAXBContext jaxbctx = this.jaxbContexts.get(clazz);
        if (jaxbctx == null) {
            jaxbctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.jaxbContexts.put(clazz, jaxbctx);
        }
        return jaxbctx;
    }

    public JAXBContext createJAXBContext(Class<?> clazz) throws JAXBException {
        JAXBContext jaxbctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
        this.addJAXBContext(jaxbctx, clazz);
        return jaxbctx;
    }

    public void addJAXBContext(JAXBContext jaxbctx, Class<?> clazz) {
        this.jaxbContexts.put(clazz, jaxbctx);
    }
}

