/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.provider.EntityProvider;

@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
@Produces(value={"application/x-www-form-urlencoded"})
public class MultivaluedMapEntityProvider
implements EntityProvider<MultivaluedMap<String, String>> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == MultivaluedMap.class) {
            try {
                ParameterizedType t = (ParameterizedType)genericType;
                Type[] ta = t.getActualTypeArguments();
                return ta.length == 2 && ta[0] == String.class && ta[1] == String.class;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    public MultivaluedMap<String, String> readFrom(Class<MultivaluedMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        Object o = context.getAttributes().get("org.everrest.provider.entity.form");
        if (o != null) {
            return (MultivaluedMap)o;
        }
        MultivaluedMapImpl form = new MultivaluedMapImpl();
        int r = -1;
        StringBuilder sb = new StringBuilder();
        try {
            while ((r = entityStream.read()) != -1) {
                if (r != 38) {
                    sb.append((char)r);
                    continue;
                }
                MultivaluedMapEntityProvider.addPair(sb.toString().trim(), form);
                sb.setLength(0);
            }
            MultivaluedMapEntityProvider.addPair(sb.toString(), form);
            context.getAttributes().put("org.everrest.provider.entity.form", form);
            return form;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static void addPair(String s, MultivaluedMap<String, String> f) throws UnsupportedEncodingException {
        String value;
        String name;
        if (s.length() == 0) {
            return;
        }
        int eq = s.indexOf(61);
        if (eq < 0) {
            name = URLDecoder.decode(s, "UTF-8");
            value = "";
        } else {
            name = URLDecoder.decode(s.substring(0, eq), "UTF-8");
            value = URLDecoder.decode(s.substring(eq + 1), "UTF-8");
        }
        f.add((Object)name, (Object)value);
    }

    public long getSize(MultivaluedMap<String, String> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.isAssignableFrom(type);
    }

    public void writeTo(MultivaluedMap<String, String> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        int i = 0;
        for (Map.Entry e : t.entrySet()) {
            for (String value : (List)e.getValue()) {
                if (i > 0) {
                    entityStream.write(38);
                }
                String name = URLEncoder.encode((String)e.getKey(), "UTF-8");
                entityStream.write(name.getBytes());
                ++i;
                if (value == null) continue;
                entityStream.write(61);
                value = URLEncoder.encode(value, "UTF-8");
                entityStream.write(value.getBytes());
            }
        }
    }
}

