/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.ext;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.everrest.core.ApplicationContext;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.provider.MultipartFormDataEntityProvider;
import org.everrest.core.impl.provider.ext.InMemoryItemFactory;

@Provider
@Consumes(value={"multipart/*"})
public class InMemoryMultipartFormDataEntityProvider
extends MultipartFormDataEntityProvider {
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public Iterator<FileItem> readFrom(Class<Iterator<FileItem>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            int bufferSize = context.getProperties().get("ws.rs.buffersize") == null ? 204800 : Integer.parseInt((String)context.getProperties().get("ws.rs.buffersize"));
            InMemoryItemFactory factory = new InMemoryItemFactory(bufferSize);
            FileUpload upload = new FileUpload((FileItemFactory)factory);
            return upload.parseRequest(this.httpRequest).iterator();
        }
        catch (FileUploadException e) {
            throw new IOException("Can't process multipart data item " + (Object)((Object)e));
        }
    }
}

