/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.everrest.core.ExtMultivaluedMap;
import org.everrest.core.impl.header.MediaTypeHelper;
import org.everrest.core.resource.ResourceMethodDescriptor;

public class ResourceMethodMap<T extends ResourceMethodDescriptor>
extends HashMap<String, List<T>>
implements ExtMultivaluedMap<String, T> {
    private static final long serialVersionUID = 8930689464134153848L;
    private static final Comparator<ResourceMethodDescriptor> RESOURCE_METHOD_COMPARATOR = new Comparator<ResourceMethodDescriptor>(){

        @Override
        public int compare(ResourceMethodDescriptor o1, ResourceMethodDescriptor o2) {
            int r = MediaTypeHelper.MEDIA_TYPE_COMPARATOR.compare(this.getLast(o1.consumes()), this.getLast(o2.consumes()));
            if (r == 0) {
                r = MediaTypeHelper.MEDIA_TYPE_COMPARATOR.compare(this.getLast(o1.produces()), this.getLast(o2.produces()));
            }
            if (r == 0) {
                r = o1.consumes().size() - o2.consumes().size();
            }
            if (r == 0) {
                r = o1.produces().size() - o2.produces().size();
            }
            return r;
        }

        private MediaType getLast(List<MediaType> l) {
            return l.get(l.size() - 1);
        }
    };

    @Override
    public List<T> getList(String httpMethod) {
        ArrayList l = (ArrayList)this.get(httpMethod);
        if (l == null) {
            l = new ArrayList();
            this.put(httpMethod, l);
        }
        return l;
    }

    public void add(String httpMethod, T resourceMethod) {
        if (resourceMethod == null) {
            return;
        }
        List<T> l = this.getList(httpMethod);
        l.add(resourceMethod);
    }

    public T getFirst(String httpMethod) {
        List<T> l = this.getList(httpMethod);
        return (T)(l != null && l.size() > 0 ? (ResourceMethodDescriptor)l.get(0) : null);
    }

    public void putSingle(String httpMethod, T resourceMethod) {
        if (resourceMethod == null) {
            return;
        }
        List<T> l = this.getList(httpMethod);
        l.clear();
        l.add(resourceMethod);
    }

    public void sort() {
        for (List l : this.values()) {
            Collections.sort(l, RESOURCE_METHOD_COMPARATOR);
        }
    }

    public Collection<String> getAllow() {
        return this.keySet();
    }
}

