/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.MessageBodyWriter;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.impl.header.HeaderHelper;

public class ServletContainerResponseWriter
implements ContainerResponseWriter {
    private HttpServletResponse servletResponse;

    public ServletContainerResponseWriter(HttpServletResponse response) {
        this.servletResponse = response;
    }

    @Override
    public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
        Object entity = response.getEntity();
        if (entity != null) {
            ServletOutputStream out = this.servletResponse.getOutputStream();
            entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
            out.flush();
        }
    }

    @Override
    public void writeHeaders(GenericContainerResponse response) throws IOException {
        if (this.servletResponse.isCommitted()) {
            return;
        }
        this.servletResponse.setStatus(response.getStatus());
        if (response.getHttpHeaders() != null) {
            for (Map.Entry e : response.getHttpHeaders().entrySet()) {
                String name = (String)e.getKey();
                for (Object o : (List)e.getValue()) {
                    String value = null;
                    if (o == null || (value = HeaderHelper.getHeaderAsString(o)) == null) continue;
                    this.servletResponse.addHeader(name, value);
                }
            }
        }
    }
}

