/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.everrest.core.ApplicationContext;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.FileCollector;
import org.everrest.core.provider.EntityProvider;

@Provider
@Consumes(value={"multipart/*"})
public class MultipartFormDataEntityProvider
implements EntityProvider<Iterator<FileItem>> {
    @Context
    private HttpServletRequest httpRequest;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == Iterator.class) {
            try {
                ParameterizedType t = (ParameterizedType)genericType;
                Type[] ta = t.getActualTypeArguments();
                return ta.length == 1 && ta[0] == FileItem.class;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    public Iterator<FileItem> readFrom(Class<Iterator<FileItem>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            ApplicationContext context = ApplicationContextImpl.getCurrent();
            Integer bufferSize = (Integer)context.getAttributes().get("org.everrest.max.buffer.size");
            DefaultFileItemFactory factory = new DefaultFileItemFactory(bufferSize.intValue(), FileCollector.getInstance().getStore());
            FileUpload upload = new FileUpload((FileItemFactory)factory);
            return upload.parseRequest(this.httpRequest).iterator();
        }
        catch (FileUploadException e) {
            throw new IOException("Can't process multipart data item " + (Object)((Object)e));
        }
    }

    public long getSize(Iterator<FileItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return false;
    }

    public void writeTo(Iterator<FileItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        throw new UnsupportedOperationException();
    }
}

