/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.impl.OutputHeadersMap;

public class ByteArrayContainerResponseWriter
implements ContainerResponseWriter {
    private byte[] body;
    private MultivaluedMap<String, Object> headers;
    private boolean commited;

    @Override
    public void writeBody(GenericContainerResponse response, MessageBodyWriter entityWriter) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Object entity = response.getEntity();
        if (entity != null) {
            entityWriter.writeTo(entity, entity.getClass(), response.getEntityType(), null, response.getContentType(), response.getHttpHeaders(), (OutputStream)out);
            this.body = out.toByteArray();
        }
    }

    @Override
    public void writeHeaders(GenericContainerResponse response) throws IOException {
        if (this.commited) {
            throw new IllegalStateException("Response has been commited. Unable write headers. ");
        }
        this.headers = new OutputHeadersMap((Map<String, List<Object>>)response.getHttpHeaders());
        this.commited = true;
    }

    public byte[] getBody() {
        return this.body;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public void reset() {
        this.body = null;
        this.headers = null;
        this.commited = false;
    }
}

