/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.json;

import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonUtils;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.impl.provider.json.JsonWriter;

public class StringValue
extends JsonValue {
    private final String value;

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public boolean getBooleanValue() {
        return Boolean.parseBoolean(this.value);
    }

    @Override
    public Number getNumberValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public byte getByteValue() {
        return this.getNumberValue().byteValue();
    }

    @Override
    public short getShortValue() {
        return this.getNumberValue().shortValue();
    }

    @Override
    public int getIntValue() {
        return this.getNumberValue().intValue();
    }

    @Override
    public long getLongValue() {
        return this.getNumberValue().longValue();
    }

    @Override
    public float getFloatValue() {
        return this.getNumberValue().floatValue();
    }

    @Override
    public double getDoubleValue() {
        return this.getNumberValue().doubleValue();
    }

    @Override
    public String toString() {
        return JsonUtils.getJsonString(this.value);
    }

    @Override
    public void writeTo(JsonWriter writer) throws JsonException {
        writer.writeString(this.value);
    }
}

