/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.impl.provider.json.JsonWriter;

public class ArrayValue
extends JsonValue {
    private final List<JsonValue> children = new ArrayList<JsonValue>();

    @Override
    public void addElement(JsonValue child) {
        this.children.add(child);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public Iterator<JsonValue> getElements() {
        return this.children.iterator();
    }

    @Override
    public int size() {
        return this.children.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        for (JsonValue v : this.children) {
            if (i > 0) {
                sb.append(',');
            }
            ++i;
            sb.append(v.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public void writeTo(JsonWriter writer) throws JsonException {
        writer.writeStartArray();
        for (JsonValue v : this.children) {
            v.writeTo(writer);
        }
        writer.writeEndArray();
    }
}

