/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.wadl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import org.everrest.core.method.MethodParameter;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.wadl.WadlGenerator;
import org.everrest.core.wadl.research.Application;
import org.everrest.core.wadl.research.Method;
import org.everrest.core.wadl.research.Param;
import org.everrest.core.wadl.research.ParamStyle;
import org.everrest.core.wadl.research.RepresentationType;
import org.everrest.core.wadl.research.Request;
import org.everrest.core.wadl.research.Resource;
import org.everrest.core.wadl.research.Resources;
import org.everrest.core.wadl.research.Response;

public class BaseWadlGeneratorImpl
implements WadlGenerator {
    @Override
    public Application createApplication() {
        return new Application();
    }

    @Override
    public Resources createResources() {
        return new Resources();
    }

    @Override
    public Resource createResource(AbstractResourceDescriptor rd) {
        if (rd.isRootResource()) {
            return this.createResource(rd.getPathValue().getPath());
        }
        return this.createResource((String)null);
    }

    @Override
    public Resource createResource(String path) {
        Resource wadlResource = new Resource();
        if (path != null) {
            wadlResource.setPath(path);
        }
        return wadlResource;
    }

    @Override
    public Method createMethod(ResourceMethodDescriptor rmd) {
        String httpMethod = rmd.getHttpMethod();
        if (httpMethod.equals("HEAD")) {
            return null;
        }
        Method wadlMethod = new Method();
        wadlMethod.setName(httpMethod);
        java.lang.reflect.Method m = rmd.getMethod();
        if (m != null) {
            wadlMethod.setId(m.getName());
        }
        return wadlMethod;
    }

    @Override
    public Request createRequest() {
        return new Request();
    }

    @Override
    public Response createResponse() {
        return new Response();
    }

    @Override
    public RepresentationType createRequestRepresentation(MediaType mediaType) {
        RepresentationType wadlRepresentation = new RepresentationType();
        wadlRepresentation.setMediaType(mediaType.toString());
        return wadlRepresentation;
    }

    @Override
    public RepresentationType createResponseRepresentation(MediaType mediaType) {
        RepresentationType wadlRepresentation = new RepresentationType();
        wadlRepresentation.setMediaType(mediaType.toString());
        return wadlRepresentation;
    }

    @Override
    public Param createParam(MethodParameter methodParameter) {
        Param wadlParameter = null;
        Annotation annotation = methodParameter.getAnnotation();
        Class<? extends Annotation> annotationClass = methodParameter.getAnnotation().annotationType();
        if (annotationClass == PathParam.class) {
            wadlParameter = new Param();
            wadlParameter.setName(((PathParam)annotation).value());
            wadlParameter.setStyle(ParamStyle.TEMPLATE);
        } else if (annotationClass == MatrixParam.class) {
            wadlParameter = new Param();
            wadlParameter.setName(((MatrixParam)annotation).value());
            wadlParameter.setStyle(ParamStyle.MATRIX);
        } else if (annotationClass == QueryParam.class) {
            wadlParameter = new Param();
            wadlParameter.setName(((QueryParam)annotation).value());
            wadlParameter.setStyle(ParamStyle.QUERY);
        } else if (annotationClass == HeaderParam.class) {
            wadlParameter = new Param();
            wadlParameter.setName(((HeaderParam)annotation).value());
            wadlParameter.setStyle(ParamStyle.HEADER);
        }
        if (wadlParameter == null) {
            return null;
        }
        Class<?> parameterClass = methodParameter.getParameterClass();
        if (parameterClass == List.class || parameterClass == Set.class || parameterClass == SortedSet.class) {
            wadlParameter.setRepeating(true);
        }
        if (methodParameter.getDefaultValue() != null) {
            wadlParameter.setDefault(methodParameter.getDefaultValue());
        }
        if (parameterClass.equals(Boolean.class) || parameterClass.equals(Boolean.TYPE)) {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xs"));
        } else if (parameterClass.equals(Byte.class) || parameterClass.equals(Byte.TYPE)) {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "byte", "xs"));
        } else if (parameterClass.equals(Short.class) || parameterClass.equals(Short.TYPE)) {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "short", "xs"));
        } else if (parameterClass.equals(Integer.class) || parameterClass.equals(Integer.TYPE)) {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "integer", "xs"));
        } else if (parameterClass.equals(Long.class) || parameterClass.equals(Long.TYPE)) {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "long", "xs"));
        } else if (parameterClass.equals(Float.class) || parameterClass.equals(Float.TYPE)) {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "float", "xs"));
        } else if (parameterClass.equals(Double.class) || parameterClass.equals(Double.TYPE)) {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "double", "xs"));
        } else {
            wadlParameter.setType(new QName("http://www.w3.org/2001/XMLSchema", "string", "xs"));
        }
        return wadlParameter;
    }
}

