/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.ObjectFactory;
import org.everrest.core.PerRequestObjectFactory;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResourcePublicationException;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.RuntimeDelegateImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.uri.UriPattern;
import org.everrest.core.util.Logger;

public class ResourceBinderImpl
implements ResourceBinder {
    private static final Logger LOG = Logger.getLogger(ResourceBinderImpl.class);
    protected static final Comparator<ObjectFactory<AbstractResourceDescriptor>> RESOURCE_COMPARATOR = new Comparator<ObjectFactory<AbstractResourceDescriptor>>(){

        @Override
        public int compare(ObjectFactory<AbstractResourceDescriptor> o1, ObjectFactory<AbstractResourceDescriptor> o2) {
            return UriPattern.URIPATTERN_COMPARATOR.compare(o1.getObjectModel().getUriPattern(), o2.getObjectModel().getUriPattern());
        }
    };
    private volatile List<ObjectFactory<AbstractResourceDescriptor>> resources = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
    private final ResourceDescriptorVisitor rdv = ResourceDescriptorValidator.getInstance();
    private final ReentrantLock lock = new ReentrantLock();

    public ResourceBinderImpl() {
        RuntimeDelegateImpl rd = new RuntimeDelegateImpl();
        RuntimeDelegate.setInstance((RuntimeDelegate)rd);
    }

    @Override
    public void addResource(Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        Path path = resourceClass.getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException("Resource class " + resourceClass.getName() + " it is not root resource. " + "Path annotation javax.ws.rs.Path is not specified for this class.");
        }
        try {
            AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resourceClass, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            if (properties != null) {
                descriptor.getProperties().putAll(properties);
            }
            this.addResource(new PerRequestObjectFactory<AbstractResourceDescriptor>(descriptor));
        }
        catch (Exception e) {
            if (e instanceof ResourcePublicationException) {
                throw (ResourcePublicationException)e;
            }
            throw new ResourcePublicationException(e.getMessage(), e);
        }
    }

    @Override
    public void addResource(Object resource, MultivaluedMap<String, String> properties) {
        Path path = resource.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException("Resource class " + resource.getClass().getName() + " it is not root resource. " + "Path annotation javax.ws.rs.Path is not specified for this class.");
        }
        try {
            AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resource.getClass(), ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            if (properties != null) {
                descriptor.getProperties().putAll(properties);
            }
            this.addResource(new SingletonObjectFactory<AbstractResourceDescriptor>(descriptor, resource));
        }
        catch (Exception e) {
            if (e instanceof ResourcePublicationException) {
                throw (ResourcePublicationException)e;
            }
            throw new ResourcePublicationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(ObjectFactory<AbstractResourceDescriptor> resourceFactory) {
        UriPattern pattern = resourceFactory.getObjectModel().getUriPattern();
        this.lock.lock();
        try {
            ArrayList<ObjectFactory<AbstractResourceDescriptor>> snapshot = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(this.resources);
            for (ObjectFactory objectFactory : snapshot) {
                if (!((AbstractResourceDescriptor)objectFactory.getObjectModel()).getUriPattern().equals(resourceFactory.getObjectModel().getUriPattern())) continue;
                if (((AbstractResourceDescriptor)objectFactory.getObjectModel()).getObjectClass() == resourceFactory.getObjectModel().getObjectClass()) {
                    return;
                }
                throw new ResourcePublicationException("Resource class " + resourceFactory.getObjectModel().getObjectClass().getName() + " can't be registered. Resource class " + ((AbstractResourceDescriptor)objectFactory.getObjectModel()).getObjectClass().getName() + " with the same pattern " + pattern + " already registered.");
            }
            snapshot.add(resourceFactory);
            Collections.sort(snapshot, RESOURCE_COMPARATOR);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Add resource: " + resourceFactory.getObjectModel());
            }
            this.resources = snapshot;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.resources = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ObjectFactory<AbstractResourceDescriptor> getMatchedResource(String requestPath, List<String> parameterValues) {
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = null;
        List<ObjectFactory<AbstractResourceDescriptor>> myResources = this.resources;
        for (ObjectFactory<AbstractResourceDescriptor> resource : myResources) {
            int len;
            if (!resource.getObjectModel().getUriPattern().match(requestPath, parameterValues) || parameterValues.get((len = parameterValues.size()) - 1) != null && !parameterValues.get(len - 1).equals("/") && 0 == resource.getObjectModel().getSubResourceMethods().size() + resource.getObjectModel().getSubResourceLocators().size()) continue;
            resourceFactory = resource;
            break;
        }
        return resourceFactory;
    }

    @Override
    public List<ObjectFactory<AbstractResourceDescriptor>> getResources() {
        List<ObjectFactory<AbstractResourceDescriptor>> myResources = this.resources;
        return new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(myResources);
    }

    @Override
    public int getSize() {
        List<ObjectFactory<AbstractResourceDescriptor>> myResources = this.resources;
        return myResources.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectFactory<AbstractResourceDescriptor> removeResource(Class<?> clazz) {
        this.lock.lock();
        try {
            ObjectFactory resource = null;
            ArrayList<ObjectFactory<AbstractResourceDescriptor>> snapshot = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(this.resources);
            Iterator iterator = snapshot.iterator();
            while (iterator.hasNext() && resource == null) {
                ObjectFactory next = (ObjectFactory)iterator.next();
                Class<?> resourceClass = ((AbstractResourceDescriptor)next.getObjectModel()).getObjectClass();
                if (!clazz.equals(resourceClass)) continue;
                resource = next;
                iterator.remove();
            }
            if (resource != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove resource: " + resource.getObjectModel());
                }
                this.resources = snapshot;
            }
            ObjectFactory objectFactory = resource;
            return objectFactory;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectFactory<AbstractResourceDescriptor> removeResource(String path) {
        this.lock.lock();
        try {
            ObjectFactory resource = null;
            ArrayList<ObjectFactory<AbstractResourceDescriptor>> snapshot = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(this.resources);
            UriPattern pattern = new UriPattern(path);
            Iterator iterator = snapshot.iterator();
            while (iterator.hasNext() && resource == null) {
                ObjectFactory next = (ObjectFactory)iterator.next();
                UriPattern resourcePattern = ((AbstractResourceDescriptor)next.getObjectModel()).getUriPattern();
                if (!pattern.equals(resourcePattern)) continue;
                resource = next;
                iterator.remove();
            }
            if (resource != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove resource: " + resource.getObjectModel());
                }
                this.resources = snapshot;
            }
            ObjectFactory objectFactory = resource;
            return objectFactory;
        }
        finally {
            this.lock.unlock();
        }
    }
}

