/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.uri;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.impl.uri.PathSegmentImpl;
import org.everrest.core.util.NoSyncByteArrayOutputStream;

public final class UriComponent {
    public static final int SCHEME = 0;
    public static final int USER_INFO = 1;
    public static final int HOST = 2;
    public static final int PORT = 3;
    public static final int PATH_SEGMENT = 4;
    public static final int PATH = 5;
    public static final int QUERY = 6;
    public static final int FRAGMENT = 7;
    public static final int SSP = 8;
    public static final String PERCENT = "%25";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[][][] ENCODED = new char[9][128][3];
    private static final int[][] ENCODING = new int[9][128];
    private static final Charset UTF8;

    private static void fillTable(int[] array, char begin, char end) {
        if (begin < '\u0000' || end < '\u0000' || begin > '\u007f' || end > '\u007f' || begin > end) {
            throw new IllegalArgumentException("Invalid range '" + begin + "' - '" + end + '\'');
        }
        for (char c = begin; c <= end; c = (char)(c + '\u0001')) {
            array[c] = 1;
        }
    }

    private static void set(int[] src, int[] dest) {
        for (int flag : src) {
            if (flag != 1) continue;
            dest[i] = 1;
        }
    }

    public static URI normalize(URI uri) {
        String oldPath = uri.getRawPath();
        String normalizedPath = UriComponent.normalize(oldPath);
        if (normalizedPath.equals(oldPath)) {
            return uri;
        }
        return UriBuilder.fromUri((URI)uri).replacePath(normalizedPath).build(new Object[0]);
    }

    private static String normalize(String path) {
        String inputBuffer = path;
        StringBuilder outputBuffer = new StringBuilder();
        if (inputBuffer.contains("//")) {
            inputBuffer = inputBuffer.replaceAll("//", "/");
        }
        while (inputBuffer.length() != 0) {
            if (inputBuffer.startsWith("../") || inputBuffer.startsWith("./")) {
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47) + 1, inputBuffer.length());
                continue;
            }
            if (inputBuffer.startsWith("/./") || inputBuffer.startsWith("/.") && UriComponent.isCompletePathSeg(".", inputBuffer)) {
                if (inputBuffer.equals("/.")) {
                    inputBuffer = "";
                    outputBuffer.append('/');
                    continue;
                }
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47, 1), inputBuffer.length());
                continue;
            }
            if (inputBuffer.startsWith("/../") || inputBuffer.startsWith("/..") && UriComponent.isCompletePathSeg("..", inputBuffer)) {
                if (inputBuffer.equals("/..")) {
                    inputBuffer = "";
                    outputBuffer.delete(outputBuffer.lastIndexOf("/") + 1, outputBuffer.length());
                    continue;
                }
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47, 1), inputBuffer.length());
                outputBuffer.delete(outputBuffer.lastIndexOf("/"), outputBuffer.length());
                continue;
            }
            if (inputBuffer.equals(".") || inputBuffer.equals("..")) {
                inputBuffer = "";
                continue;
            }
            if (inputBuffer.indexOf(47) != inputBuffer.lastIndexOf(47)) {
                outputBuffer.append(inputBuffer.substring(0, inputBuffer.indexOf(47, 1)));
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47, 1));
                continue;
            }
            outputBuffer.append(inputBuffer);
            inputBuffer = "";
        }
        return outputBuffer.toString();
    }

    private static boolean isCompletePathSeg(String segment, String path) {
        return path.equals('/' + segment) || path.charAt(path.indexOf(segment) + segment.length()) == '/';
    }

    public static String encode(String str, int component, boolean containsUriParams) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        return UriComponent.encodingInt(str, component, containsUriParams, false);
    }

    public static String validate(String str, int component, boolean containsUriParams) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '%' || (ch == '{' || ch == '}') && containsUriParams || ch < '\u0080' && !UriComponent.needEncode(ch, component)) continue;
            throw new IllegalArgumentException("Illegal character, index " + i + ": " + str);
        }
        return str;
    }

    public static String recognizeEncode(String str, int component, boolean containsUriParams) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        return UriComponent.encodingInt(str, component, containsUriParams, true);
    }

    private static String encodingInt(String str, int component, boolean containsUriParams, boolean recognizeEncoded) {
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        boolean encode = false;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            encode |= UriComponent.needEncode(ch, component);
            if (ch == '%' && recognizeEncoded) {
                if (UriComponent.checkHexCharacters(str, i)) {
                    sb.append(ch);
                    sb.append(str.charAt(++i));
                    sb.append(str.charAt(++i));
                    continue;
                }
                sb.append(PERCENT);
                continue;
            }
            if (containsUriParams && (ch == '{' || ch == '}')) {
                sb.append(ch);
                continue;
            }
            if (ch < '\u0080') {
                if (UriComponent.needEncode(ch, component)) {
                    sb.append(ENCODED[component][ch]);
                    continue;
                }
                sb.append(ch);
                continue;
            }
            UriComponent.addUTF8Encoded(ch, sb);
        }
        if (encode) {
            return sb.toString();
        }
        return str;
    }

    public static String decode(String str, int component) {
        if (str == null) {
            throw new IllegalArgumentException("Decoded string is null");
        }
        int length = str.length();
        if (length < 3 && str.indexOf(37) > 0) {
            throw new IllegalArgumentException("Malformed string " + str);
        }
        int p = str.lastIndexOf(37);
        if (p > 0 && p > length - 3) {
            throw new IllegalArgumentException("Malformed string at index " + p);
        }
        p = 0;
        StringBuilder sb = new StringBuilder();
        NoSyncByteArrayOutputStream buff = null;
        block4: while (p < length) {
            char c = str.charAt(p);
            switch (c) {
                case '%': {
                    if (buff == null) {
                        buff = new NoSyncByteArrayOutputStream(4);
                    } else {
                        buff.reset();
                    }
                    p = UriComponent.percentDecode(str, p, buff);
                    byte[] bytes = buff.toByteArray();
                    if (bytes.length == 1 && (bytes[0] & 0xFF) < 128) {
                        sb.append((char)bytes[0]);
                        continue block4;
                    }
                    sb.append(UTF8.decode(ByteBuffer.wrap(bytes)));
                    continue block4;
                }
                case '+': {
                    sb.append(' ');
                    ++p;
                    continue block4;
                }
            }
            sb.append(c);
            ++p;
        }
        return sb.toString();
    }

    private static boolean needEncode(char ch, int component) {
        int[] allowed = ENCODING[component];
        return allowed.length <= ch || allowed[ch] == 0;
    }

    private static void addUTF8Encoded(char c, StringBuilder sb) {
        ByteBuffer buf = UTF8.encode(CharBuffer.wrap(Character.toChars(c)));
        while (buf.hasRemaining()) {
            int b = buf.get() & 0xFF;
            sb.append('%');
            sb.append(HEX_DIGITS[b >> 4]);
            sb.append(HEX_DIGITS[b & 0xF]);
        }
    }

    private static int percentDecode(String str, int p, ByteArrayOutputStream out) {
        int length = str.length();
        do {
            char hc = UriComponent.getHexCharacter(str, ++p);
            char lc = UriComponent.getHexCharacter(str, ++p);
            int r = (Character.isDigit(hc) ? hc - 48 : hc - 65 + 10) << 4 | (Character.isDigit(lc) ? lc - 48 : lc - 65 + 10);
            out.write((byte)r);
        } while (++p != length && str.charAt(p) == '%');
        return p;
    }

    public static boolean checkHexCharacters(String s, int p) {
        if (p > s.length() - 3) {
            return false;
        }
        try {
            UriComponent.getHexCharacter(s, ++p);
            UriComponent.getHexCharacter(s, ++p);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static char getHexCharacter(String s, int p) {
        char c = s.charAt(p);
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c >= 'A' && c <= 'F') {
            return c;
        }
        if (c >= 'a' && c <= 'f') {
            return Character.toUpperCase(c);
        }
        throw new IllegalArgumentException("Malformed string at index " + p);
    }

    public static List<PathSegment> parsePathSegments(String path, boolean decode) {
        ArrayList<PathSegment> result = new ArrayList<PathSegment>();
        if (path != null && !path.isEmpty()) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            int p = 0;
            int n = 0;
            while (n < path.length()) {
                n = path.indexOf(47, p);
                if (n < 0) {
                    n = path.length();
                }
                result.add(PathSegmentImpl.fromString(path.substring(p, n), decode));
                p = n + 1;
            }
        }
        return result;
    }

    public static MultivaluedMap<String, String> parseQueryString(String rawQuery, boolean decode) {
        MultivaluedMapImpl result = new MultivaluedMapImpl();
        if (rawQuery != null && !rawQuery.isEmpty()) {
            int p = 0;
            int n = 0;
            while (n < rawQuery.length()) {
                String value;
                String name;
                String pair;
                n = rawQuery.indexOf(38, p);
                if (n < 0) {
                    n = rawQuery.length();
                }
                if ((pair = rawQuery.substring(p, n)).isEmpty()) continue;
                int eq = pair.indexOf(61);
                if (eq < 0) {
                    name = pair;
                    value = "";
                } else {
                    name = pair.substring(0, eq);
                    value = pair.substring(eq + 1);
                }
                result.add(decode ? UriComponent.decode(name, 6) : name, decode ? UriComponent.decode(value, 6) : value);
                p = n + 1;
            }
        }
        return result;
    }

    private UriComponent() {
    }

    static {
        for (int i = 0; i <= 8; ++i) {
            UriComponent.ENCODING[i] = new int[128];
        }
        int[] alphabet = new int[128];
        UriComponent.fillTable(alphabet, 'a', 'z');
        UriComponent.fillTable(alphabet, 'A', 'Z');
        int[] digit = new int[128];
        UriComponent.fillTable(digit, '0', '9');
        int[] unreserved = new int[128];
        UriComponent.set(alphabet, unreserved);
        UriComponent.set(digit, unreserved);
        unreserved[45] = 1;
        unreserved[46] = 1;
        unreserved[95] = 1;
        unreserved[126] = 1;
        int[] gendelim = new int[128];
        gendelim[58] = 1;
        gendelim[47] = 1;
        gendelim[63] = 1;
        gendelim[35] = 1;
        gendelim[91] = 1;
        gendelim[93] = 1;
        gendelim[64] = 1;
        int[] subdelim = new int[128];
        subdelim[33] = 1;
        subdelim[36] = 1;
        subdelim[38] = 1;
        subdelim[39] = 1;
        subdelim[40] = 1;
        subdelim[41] = 1;
        subdelim[42] = 1;
        subdelim[43] = 1;
        subdelim[44] = 1;
        subdelim[59] = 1;
        subdelim[61] = 1;
        UriComponent.set(alphabet, ENCODING[0]);
        UriComponent.set(digit, ENCODING[0]);
        UriComponent.ENCODING[0][45] = 1;
        UriComponent.ENCODING[0][43] = 1;
        UriComponent.ENCODING[0][46] = 1;
        UriComponent.set(unreserved, ENCODING[1]);
        UriComponent.set(subdelim, ENCODING[1]);
        UriComponent.ENCODING[1][58] = 1;
        UriComponent.set(unreserved, ENCODING[2]);
        UriComponent.set(subdelim, ENCODING[2]);
        UriComponent.set(digit, ENCODING[3]);
        UriComponent.set(unreserved, ENCODING[4]);
        UriComponent.set(subdelim, ENCODING[4]);
        UriComponent.ENCODING[4][58] = 1;
        UriComponent.ENCODING[4][64] = 1;
        UriComponent.set(unreserved, ENCODING[5]);
        UriComponent.set(subdelim, ENCODING[5]);
        UriComponent.ENCODING[5][58] = 1;
        UriComponent.ENCODING[5][64] = 1;
        UriComponent.ENCODING[5][47] = 1;
        UriComponent.set(unreserved, ENCODING[6]);
        UriComponent.ENCODING[6][45] = 1;
        UriComponent.ENCODING[6][46] = 1;
        UriComponent.ENCODING[6][95] = 1;
        UriComponent.ENCODING[6][126] = 1;
        UriComponent.ENCODING[6][33] = 1;
        UriComponent.ENCODING[6][36] = 1;
        UriComponent.ENCODING[6][39] = 1;
        UriComponent.ENCODING[6][40] = 1;
        UriComponent.ENCODING[6][41] = 1;
        UriComponent.ENCODING[6][42] = 1;
        UriComponent.ENCODING[6][44] = 1;
        UriComponent.ENCODING[6][59] = 1;
        UriComponent.ENCODING[6][58] = 1;
        UriComponent.ENCODING[6][64] = 1;
        UriComponent.ENCODING[6][63] = 1;
        UriComponent.ENCODING[6][47] = 1;
        System.arraycopy(ENCODING[6], 0, ENCODING[7], 0, ENCODING[6].length);
        UriComponent.set(unreserved, ENCODING[8]);
        UriComponent.set(subdelim, ENCODING[8]);
        UriComponent.set(gendelim, ENCODING[8]);
        for (int i = 0; i <= 8; ++i) {
            for (int j = 0; j < 128; ++j) {
                if (ENCODING[i][j] != 0) continue;
                UriComponent.ENCODED[i][j] = new char[]{'%', HEX_DIGITS[j >> 4], HEX_DIGITS[j & 0xF]};
            }
        }
        UTF8 = Charset.forName("UTF-8");
    }
}

