/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.resource;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.ConstructorDescriptor;
import org.everrest.core.FieldInjector;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.ObjectModel;
import org.everrest.core.method.MethodParameter;
import org.everrest.core.provider.ProviderDescriptor;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.resource.ResourceMethodMap;
import org.everrest.core.resource.SubResourceLocatorDescriptor;
import org.everrest.core.resource.SubResourceMethodDescriptor;

public class ResourceDescriptorValidator
implements ResourceDescriptorVisitor {
    private static final ResourceDescriptorValidator INSTANCE = new ResourceDescriptorValidator();

    public static ResourceDescriptorValidator getInstance() {
        return INSTANCE;
    }

    private ResourceDescriptorValidator() {
    }

    @Override
    public void visitAbstractResourceDescriptor(AbstractResourceDescriptor ard) {
        if (ard.isRootResource() && ard.getPathValue().getPath().length() == 0) {
            String msg = "Resource class " + ard.getObjectClass() + " is root resource but path value empty, see javax.ws.rs.Path#value()";
            throw new RuntimeException(msg);
        }
        this.checkObjectModel(ard);
        for (List l : ard.getResourceMethods().values()) {
            for (ResourceMethodDescriptor rmd : l) {
                rmd.accept(this);
            }
        }
        for (ResourceMethodMap rmm : ard.getSubResourceMethods().values()) {
            for (List l : rmm.values()) {
                for (SubResourceMethodDescriptor rmd : l) {
                    rmd.accept(this);
                }
            }
        }
        for (SubResourceLocatorDescriptor loc : ard.getSubResourceLocators().values()) {
            loc.accept(this);
        }
    }

    @Override
    public void visitResourceMethodDescriptor(ResourceMethodDescriptor rmd) {
        this.checkMethodParameters(rmd);
    }

    @Override
    public void visitSubResourceLocatorDescriptor(SubResourceLocatorDescriptor srld) {
        if (srld.getPathValue().getPath().length() == 0) {
            String msg = "Path value is empty for method " + srld.getMethod().getName() + " in resource class " + srld.getParentResource().getObjectClass() + ", see javax.ws.rs.Path#value()";
            throw new RuntimeException(msg);
        }
        this.checkMethodParameters(srld);
    }

    @Override
    public void visitSubResourceMethodDescriptor(SubResourceMethodDescriptor srmd) {
        if (srmd.getPathValue().getPath().length() == 0) {
            String msg = "Path value is null or empty for method " + srmd.getMethod().getName() + " in resource class " + srmd.getParentResource().getObjectClass() + ", see javax.ws.rs.Path#value()";
            throw new RuntimeException(msg);
        }
        this.checkMethodParameters(srmd);
    }

    private void checkMethodParameters(ResourceMethodDescriptor rmd) {
        List<MethodParameter> l = rmd.getMethodParameters();
        boolean entity = false;
        boolean form = false;
        for (int i = 0; i < l.size(); ++i) {
            MethodParameter mp = l.get(i);
            if (mp.getAnnotation() == null) {
                if (!entity) {
                    entity = true;
                    if (!form) continue;
                    this.checkFormParam(mp.getParameterClass(), mp.getGenericType());
                    continue;
                }
                String msg = "Wrong or absent annotation at parameter with index " + i + " at " + rmd.getParentResource().getObjectClass() + "#" + rmd.getMethod().getName();
                throw new RuntimeException(msg);
            }
            if (mp.getAnnotation().annotationType() != FormParam.class) continue;
            form = true;
            if (!entity) continue;
            this.checkFormParam(mp.getParameterClass(), mp.getGenericType());
        }
    }

    private void checkMethodParameters(SubResourceLocatorDescriptor srld) {
        List<MethodParameter> l = srld.getMethodParameters();
        for (int i = 0; i < l.size(); ++i) {
            MethodParameter mp = l.get(i);
            if (mp.getAnnotation() != null) continue;
            String msg = "Wrong or absent annotation at parameter with index " + i + " at " + srld.getParentResource().getObjectClass() + "#" + srld.getMethod().getName();
            throw new RuntimeException(msg);
        }
    }

    private void checkFormParam(Class clazz, Type type) {
        Type[] actualTypes;
        if (MultivaluedMap.class == clazz && type instanceof ParameterizedType && (actualTypes = ((ParameterizedType)type).getActualTypeArguments()).length == 2 && String.class == actualTypes[0] && String.class == actualTypes[1]) {
            return;
        }
        String msg = "If a any method parameter is annotated with FormParam then type of entity parameter MUST be MultivalueMap<String, String> or FormEntity";
        throw new RuntimeException(msg);
    }

    @Override
    public void visitConstructorInjector(ConstructorDescriptor ci) {
    }

    @Override
    public void visitFieldInjector(FieldInjector fi) {
    }

    @Override
    public void visitFilterDescriptor(FilterDescriptor fd) {
        this.checkObjectModel(fd);
    }

    @Override
    public void visitProviderDescriptor(ProviderDescriptor pd) {
        this.checkObjectModel(pd);
    }

    protected void checkObjectModel(ObjectModel model) {
        for (ConstructorDescriptor c : model.getConstructorDescriptors()) {
            c.accept(this);
        }
        for (FieldInjector f : model.getFieldInjectors()) {
            f.accept(this);
        }
    }
}

