/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.uri;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.everrest.core.impl.uri.UriComponent;
import org.everrest.core.uri.UriPattern;

public class UriBuilderImpl
extends UriBuilder {
    private String schema;
    private String userInfo;
    private String host;
    private int port = -1;
    private StringBuilder path = new StringBuilder();
    private StringBuilder query = new StringBuilder();
    private String fragment;

    public UriBuilderImpl() {
    }

    public URI buildFromMap(Map<String, ?> values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, true);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException((Throwable)e);
        }
    }

    public URI buildFromEncodedMap(Map<String, ?> values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, false);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException((Throwable)e);
        }
    }

    public URI build(Object ... values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, true);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException((Throwable)e);
        }
    }

    public URI buildFromEncoded(Object ... values) {
        this.encode();
        String uri = UriPattern.createUriWithValues(this.schema, this.userInfo, this.host, this.port, this.path.toString(), this.query.toString(), this.fragment, values, false);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException((Throwable)e);
        }
    }

    private void encode() {
        this.encodePath();
        this.encodeQuery();
        this.encodeFragment();
    }

    private void encodePath() {
        int p;
        if (this.path.length() > 0 && (p = this.path.indexOf(";", (p = this.path.lastIndexOf("/")) < 0 ? 0 : p)) >= 0) {
            String t = this.path.toString();
            this.path.setLength(0);
            this.path.append(UriComponent.recognizeEncode(t, 5, true));
        }
    }

    private void encodeQuery() {
        if (this.query.length() > 0) {
            String str = this.query.toString();
            this.query.setLength(0);
            int p = 0;
            while (p < str.length()) {
                if (str.charAt(p) == '=') {
                    throw new UriBuilderException("Query parameter name is empty. ");
                }
                int n = str.indexOf(38, p);
                if (n < 0) {
                    n = str.length();
                }
                if (n > p) {
                    int eq;
                    String pair = str.substring(p, n);
                    if (this.query.length() > 0) {
                        this.query.append('&');
                    }
                    if ((eq = pair.indexOf(61)) == -1) {
                        this.query.append(UriComponent.recognizeEncode(pair, 6, true));
                    } else if (eq == pair.length() - 1) {
                        this.query.append(UriComponent.recognizeEncode(pair.substring(0, eq), 6, true));
                    } else {
                        this.query.append(UriComponent.recognizeEncode(pair.substring(0, eq), 6, true));
                        this.query.append('=');
                        this.query.append(UriComponent.recognizeEncode(pair.substring(eq + 1), 6, true));
                    }
                }
                p = n + 1;
            }
        }
    }

    private void encodeFragment() {
        if (this.fragment != null && !this.fragment.isEmpty()) {
            this.fragment = UriComponent.recognizeEncode(this.fragment, 7, true);
        }
    }

    public UriBuilder clone() {
        return new UriBuilderImpl(this);
    }

    private UriBuilderImpl(UriBuilderImpl cloned) {
        this.schema = cloned.schema;
        this.userInfo = cloned.userInfo;
        this.host = cloned.host;
        this.port = cloned.port;
        this.path = new StringBuilder(cloned.path);
        this.query = new StringBuilder(cloned.query);
        this.fragment = cloned.fragment;
    }

    public UriBuilder fragment(String fragment) {
        this.fragment = fragment == null ? null : UriComponent.encode(fragment, 7, true);
        return this;
    }

    public UriBuilder host(String host) {
        this.host = host == null ? null : UriComponent.recognizeEncode(host, 2, true);
        return this;
    }

    public UriBuilder matrixParam(String name, Object ... values) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values are null");
        }
        for (Object o : values) {
            if (o == null) {
                throw new IllegalArgumentException("Value is null");
            }
            this.path.append(';');
            this.path.append(name);
            this.path.append('=');
            this.path.append(o.toString());
        }
        return this;
    }

    public UriBuilder path(String p) {
        if (p == null) {
            throw new IllegalArgumentException("Path segments are null");
        }
        if (!p.isEmpty()) {
            boolean startSlash;
            p = UriComponent.recognizeEncode(p, 5, true);
            boolean finalSlash = this.path.length() > 0 && this.path.charAt(this.path.length() - 1) == '/';
            boolean bl = startSlash = p.charAt(0) == '/';
            if (finalSlash && startSlash) {
                if (p.length() > 1) {
                    this.path.append(p.substring(1));
                }
            } else if (this.path.length() > 0 && !finalSlash && !startSlash) {
                this.path.append('/');
                this.path.append(p);
            } else {
                this.path.append(p);
            }
        }
        return this;
    }

    public UriBuilder path(Class resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        Path annotation = resource.getAnnotation(Path.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Class is not annotated with javax.ws.rs.Path");
        }
        return this.path(annotation.value());
    }

    public UriBuilder path(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Method is null");
        }
        Path p = method.getAnnotation(Path.class);
        return p == null ? this : this.path(p.value());
    }

    public UriBuilder path(Class resource, String method) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource is null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Method name is null");
        }
        Method[] methods = resource.getMethods();
        Method matched = null;
        for (Method m : methods) {
            if (matched != null && m.getName().equals(method)) {
                throw new IllegalArgumentException("More then one method with name " + method + " found");
            }
            if (!m.getName().equals(method)) continue;
            matched = m;
        }
        if (matched == null) {
            throw new IllegalArgumentException("Method " + method + " not found at resource class " + resource.getName());
        }
        this.path(matched);
        return this;
    }

    public UriBuilder port(int port) {
        if (port < -1) {
            throw new IllegalArgumentException("Invalid port " + port);
        }
        this.port = port;
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values are null");
        }
        for (Object o : values) {
            if (o == null) {
                throw new IllegalArgumentException("Value is null");
            }
            if (this.query.length() > 0) {
                this.query.append('&');
            }
            this.query.append(name);
            this.query.append('=');
            this.query.append(o.toString());
        }
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) {
        String str;
        int p;
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (this.path.length() > 0 && (p = str.indexOf(59, (p = (str = this.path.toString()).lastIndexOf(47)) < 0 ? 0 : p)) >= 0) {
            this.path.setLength(p);
            while (p < str.length()) {
                int n = str.indexOf(59, p);
                if (n < 0) {
                    n = str.length();
                }
                if (n > p) {
                    String pairName;
                    String pair = str.substring(p, n);
                    int eq = pair.indexOf(61);
                    String string = pairName = eq > 0 ? pair.substring(0, eq) : pair;
                    if (!name.equals(pairName)) {
                        if (this.path.length() > 0) {
                            this.path.append(';');
                        }
                        this.path.append(pair);
                    }
                }
                p = n + 1;
            }
        }
        if (values != null && values.length > 0) {
            this.matrixParam(name, values);
        }
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) {
        int p;
        if (this.path.length() > 0 && (p = this.path.indexOf(";", (p = this.path.lastIndexOf("/")) < 0 ? 0 : p)) >= 0) {
            this.path.setLength(p);
        }
        if (matrix != null && !matrix.isEmpty()) {
            this.path.append(';');
            this.path.append(matrix);
        }
        return this;
    }

    public UriBuilder replacePath(String p) {
        this.path.setLength(0);
        if (p != null && !p.isEmpty()) {
            this.path(p);
        }
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (this.query.length() > 0) {
            int p = 0;
            String str = this.query.toString();
            this.query.setLength(0);
            while (p < str.length()) {
                int n = str.indexOf(38, p);
                if (n < 0) {
                    n = str.length();
                }
                if (n > p) {
                    String pairName;
                    String pair = str.substring(p, n);
                    int eq = pair.indexOf(61);
                    String string = pairName = eq > 0 ? pair.substring(0, eq) : pair;
                    if (!name.equals(pairName)) {
                        if (this.query.length() > 0) {
                            this.query.append('&');
                        }
                        this.query.append(pair);
                    }
                }
                p = n + 1;
            }
        }
        if (values != null && values.length > 0) {
            this.queryParam(name, values);
        }
        return this;
    }

    public UriBuilder replaceQuery(String queryString) {
        this.query.setLength(0);
        if (queryString != null && !queryString.isEmpty()) {
            this.query.append(queryString);
        }
        return this;
    }

    public UriBuilder scheme(String schema) {
        this.schema = schema != null ? UriComponent.validate(schema, 0, true) : null;
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) {
        URI uri;
        if (ssp == null) {
            throw new IllegalArgumentException("Scheme specific part (ssp) is null");
        }
        StringBuilder sb = new StringBuilder();
        if (this.schema != null) {
            sb.append(this.schema);
            sb.append(':');
            sb.append(UriComponent.recognizeEncode(ssp, 8, true));
        }
        if (this.fragment != null && !this.fragment.isEmpty()) {
            sb.append('#');
            sb.append(this.fragment);
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.userInfo = uri.getRawUserInfo();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path.setLength(0);
        this.path.append(uri.getRawPath());
        this.query.setLength(0);
        this.query.append(uri.getRawQuery() != null ? uri.getRawQuery() : "");
        return this;
    }

    public UriBuilder segment(String ... segments) {
        if (segments == null) {
            throw new IllegalArgumentException("Path segments is null");
        }
        int length = segments.length;
        for (int i = 0; i < length; ++i) {
            this.path(segments[i]);
        }
        return this;
    }

    public UriBuilder uri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null");
        }
        if (uri.getScheme() != null) {
            this.schema = uri.getScheme();
        }
        if (uri.getRawUserInfo() != null) {
            this.userInfo = uri.getRawUserInfo();
        }
        if (uri.getHost() != null) {
            this.host = uri.getHost();
        }
        if (uri.getPort() != -1) {
            this.port = uri.getPort();
        }
        if (uri.getRawPath() != null && !uri.getRawPath().isEmpty()) {
            this.path.setLength(0);
            this.path.append(uri.getRawPath());
        }
        if (uri.getRawQuery() != null && !uri.getRawQuery().isEmpty()) {
            this.query.setLength(0);
            this.query.append(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    public UriBuilder userInfo(String userInfo) {
        this.userInfo = userInfo != null ? UriComponent.recognizeEncode(userInfo, 1, true) : null;
        return this;
    }
}

