/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.everrest.core.Filter;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.util.Logger;
import org.scannotation.AnnotationDB;
import org.scannotation.WarUrlFinder;

public class EverrestServletContextInitializer {
    public static final String EVERREST_SCAN_COMPONENTS = "org.everrest.scan.components";
    public static final String EVERREST_SCAN_SKIP_PACKAGES = "org.everrest.scan.skip.packages";
    public static final String JAXRS_APPLICATION = "javax.ws.rs.Application";
    private static final Logger LOG = Logger.getLogger(EverrestServletContextInitializer.class);
    protected final ServletContext ctx;

    public EverrestServletContextInitializer(ServletContext ctx) {
        this.ctx = ctx;
    }

    public Application getApplication() {
        Application application = null;
        String applicationFQN = this.getParameter(JAXRS_APPLICATION);
        boolean scan = this.getBoolean(EVERREST_SCAN_COMPONENTS, false);
        if (applicationFQN != null) {
            if (scan) {
                String msg = "Scan of JAX-RS components is disabled cause to specified 'javax.ws.rs.Application'.";
                LOG.warn(msg);
            }
            try {
                Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(applicationFQN);
                application = (Application)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (scan) {
            try {
                URL classes = WarUrlFinder.findWebInfClassesPath((ServletContext)this.ctx);
                URL[] libs = WarUrlFinder.findWebInfLibClasspaths((ServletContext)this.ctx);
                AnnotationDB annotationDB = new AnnotationDB();
                ArrayList<String> skip = new ArrayList<String>();
                String skipParameter = this.ctx.getInitParameter(EVERREST_SCAN_SKIP_PACKAGES);
                if (skipParameter != null) {
                    for (String s : skipParameter.split(",")) {
                        skip.add(s.trim());
                    }
                }
                skip.add("org.everrest.core");
                skip.add("javax.ws.rs");
                annotationDB.setIgnoredPackages(skip.toArray(new String[skip.size()]));
                annotationDB.setScanFieldAnnotations(false);
                annotationDB.setScanMethodAnnotations(false);
                annotationDB.setScanParameterAnnotations(false);
                if (classes != null) {
                    annotationDB.scanArchives(new URL[]{classes});
                }
                annotationDB.scanArchives(libs);
                final HashSet scanned = new HashSet();
                Map results = annotationDB.getAnnotationIndex();
                for (String annotation : new String[]{Path.class.getName(), Provider.class.getName(), Filter.class.getName()}) {
                    if (results.get(annotation) == null) continue;
                    for (String fqn : (Set)results.get(annotation)) {
                        try {
                            Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(fqn);
                            if (cl.isInterface() || Modifier.isAbstract(cl.getModifiers())) {
                                LOG.info("Skip abstract class or interface " + fqn);
                                continue;
                            }
                            scanned.add(cl);
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                application = new Application(){

                    public Set<Class<?>> getClasses() {
                        return scanned;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return application;
    }

    public EverrestConfiguration getConfiguration() {
        EverrestConfiguration config = new EverrestConfiguration();
        config.setHttpMethodOverride(this.getBoolean("org.everrest.http.method.override", true));
        config.setNormalizeUri(this.getBoolean("org.everrest.normalize.uri", false));
        config.setCheckSecurity(this.getBoolean("org.everrest.security", true));
        config.setAsynchronousSupported(this.getBoolean("org.everrest.asynchronous", true));
        config.setAsynchronousPoolSize(this.getNumber("org.everrest.asynchronous.pool.size", 10.0).intValue());
        config.setAsynchronousQueueSize(this.getNumber("org.everrest.asynchronous.queue.size", 100.0).intValue());
        config.setAsynchronousCacheSize(this.getNumber("org.everrest.asynchronous.cache.size", 512.0).intValue());
        config.setAsynchronousJobTimeout(this.getNumber("org.everrest.asynchronous.job.timeout", 60.0).intValue());
        config.setMaxBufferSize(this.getNumber("org.everrest.max.buffer.size", 204800.0).intValue());
        config.setProperty(EverrestConfiguration.METHOD_INVOKER_DECORATOR_FACTORY, this.getParameter(EverrestConfiguration.METHOD_INVOKER_DECORATOR_FACTORY));
        return config;
    }

    public String getParameter(String name) {
        String str = this.ctx.getInitParameter(name);
        if (str != null) {
            return str.trim();
        }
        return null;
    }

    public boolean getBoolean(String name, boolean def) {
        String str = this.getParameter(name);
        if (str != null) {
            return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "on".equalsIgnoreCase(str) || "1".equals(str);
        }
        return def;
    }

    public Double getNumber(String name, double def) {
        String str = this.getParameter(name);
        if (str != null) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return def;
    }
}

