/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.uri;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everrest.core.impl.uri.UriComponent;
import org.everrest.core.uri.UriTemplateParser;

public class UriPattern {
    public static final Comparator<UriPattern> URIPATTERN_COMPARATOR = new UriPatternComparator();
    private static final String URI_PATTERN_TAIL = "(/.*)?";
    private final List<String> parameterNames;
    private final String template;
    private final int numberOfCharacters;
    private final Pattern pattern;
    private final String regex;
    private final int[] groupIndexes;

    public UriPattern(String template) {
        if (template.length() > 0 && template.charAt(0) != '/') {
            template = '/' + template;
        }
        UriTemplateParser parser = new UriTemplateParser(template);
        this.template = parser.getTemplate();
        this.parameterNames = Collections.unmodifiableList(parser.getParameterNames());
        this.numberOfCharacters = parser.getNumberOfLiteralCharacters();
        int[] indexes = parser.getGroupIndexes();
        if (indexes != null) {
            this.groupIndexes = new int[indexes.length + 1];
            System.arraycopy(indexes, 0, this.groupIndexes, 0, indexes.length);
            this.groupIndexes[this.groupIndexes.length - 1] = indexes[indexes.length - 1] + 1;
        } else {
            this.groupIndexes = null;
        }
        String regex = parser.getRegex();
        if (regex.endsWith("/")) {
            regex = regex.substring(0, regex.length() - 1);
        }
        this.regex = regex + URI_PATTERN_TAIL;
        this.pattern = Pattern.compile(this.regex);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && this.getRegex().equals(((UriPattern)obj).getRegex());
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.regex.hashCode();
        return hash;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getNumberOfLiteralCharacters() {
        return this.numberOfCharacters;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public boolean match(String uri, List<String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("list is null");
        }
        if (uri == null || uri.isEmpty()) {
            return this.pattern == null;
        }
        if (this.pattern == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        parameters.clear();
        if (this.groupIndexes == null) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                parameters.add(m.group(i));
            }
        } else {
            for (int i = 0; i < this.groupIndexes.length - 1; ++i) {
                parameters.add(m.group(this.groupIndexes[i]));
            }
        }
        return true;
    }

    public String toString() {
        return this.regex;
    }

    public static String createUriWithValues(String schema, String userInfo, String host, int port, String path, String query, String fragment, Map<String, ?> values, boolean encode) {
        StringBuilder sb = new StringBuilder();
        if (schema != null) {
            UriPattern.appendUriPart(sb, schema, 0, values, false);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != -1) {
            sb.append('/');
            sb.append('/');
            if (userInfo != null && !userInfo.isEmpty()) {
                UriPattern.appendUriPart(sb, userInfo, 1, values, encode);
                sb.append('@');
            }
            if (host != null) {
                UriPattern.appendUriPart(sb, host, 2, values, encode);
            }
            if (port != -1) {
                sb.append(':');
                UriPattern.appendUriPart(sb, Integer.toString(port), 3, values, encode);
            }
        }
        if (path != null && !path.isEmpty()) {
            if (sb.length() > 0 && path.charAt(0) != '/') {
                sb.append('/');
            }
            UriPattern.appendUriPart(sb, path, 5, values, encode);
        }
        if (query != null && !query.isEmpty()) {
            sb.append('?');
            UriPattern.appendUriPart(sb, query, 6, values, encode);
        }
        if (fragment != null && !fragment.isEmpty()) {
            sb.append('#');
            UriPattern.appendUriPart(sb, fragment, 7, values, encode);
        }
        return sb.toString();
    }

    public static String createUriWithValues(String schema, String userInfo, String host, int port, String path, String query, String fragment, Object[] values, boolean encode) {
        HashMap<String, String> m = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        int p = 0;
        if (schema != null) {
            p = UriPattern.appendUriPart(sb, schema, 0, values, p, m, false);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != -1) {
            sb.append('/');
            sb.append('/');
            if (userInfo != null && !userInfo.isEmpty()) {
                p = UriPattern.appendUriPart(sb, userInfo, 1, values, p, m, encode);
                sb.append('@');
            }
            if (host != null) {
                p = UriPattern.appendUriPart(sb, host, 2, values, p, m, encode);
            }
            if (port != -1) {
                sb.append(':');
                p = UriPattern.appendUriPart(sb, Integer.toString(port), 3, values, p, m, encode);
            }
        }
        if (path != null && !path.isEmpty()) {
            if (sb.length() > 0 && path.charAt(0) != '/') {
                sb.append('/');
            }
            p = UriPattern.appendUriPart(sb, path, 5, values, p, m, encode);
        }
        if (query != null && !query.isEmpty()) {
            sb.append('?');
            p = UriPattern.appendUriPart(sb, query, 6, values, p, m, encode);
        }
        if (fragment != null && !fragment.isEmpty()) {
            sb.append('#');
            UriPattern.appendUriPart(sb, fragment, 7, values, p, m, encode);
        }
        return sb.toString();
    }

    private static void appendUriPart(StringBuilder sb, String uriPart, int component, Map<String, ?> values, boolean encode) {
        int length = uriPart.length();
        int lastTemplate = 0;
        for (int i = 0; i < length; ++i) {
            char c = uriPart.charAt(i);
            if (c != '{') continue;
            sb.append(uriPart, lastTemplate, i);
            lastTemplate = i;
            while (++i < length && (c = uriPart.charAt(i)) != '}') {
            }
            if (c != '}') {
                throw new IllegalArgumentException("Invalid URI template " + uriPart + ". Opened '{' is not closed by '}'. ");
            }
            String name = uriPart.substring(lastTemplate + 1, i);
            Object o = values.get(name);
            if (o == null) {
                throw new IllegalArgumentException("Not found corresponding value for parameter " + name);
            }
            String value = o.toString();
            sb.append(encode ? UriComponent.encode(value, component, true) : UriComponent.recognizeEncode(value, component, true));
            lastTemplate = i + 1;
        }
        if (lastTemplate == 0) {
            sb.append(uriPart);
        } else if (lastTemplate < length) {
            sb.append(uriPart, lastTemplate, length);
        }
    }

    private static int appendUriPart(StringBuilder sb, String uriPart, int component, Object[] sourceValues, int offset, Map<String, String> values, boolean encode) {
        int length = uriPart.length();
        int lastTemplate = 0;
        for (int i = 0; i < length; ++i) {
            char c = uriPart.charAt(i);
            if (c != '{') continue;
            sb.append(uriPart, lastTemplate, i);
            lastTemplate = i;
            while (++i < length && (c = uriPart.charAt(i)) != '}') {
            }
            if (c != '}') {
                throw new IllegalArgumentException("Invalid URI template " + uriPart + ". Opened '{' is not closed by '}'. ");
            }
            String paramName = uriPart.substring(lastTemplate + 1, i);
            String value = values.get(paramName);
            if (value != null) {
                sb.append(value);
            } else {
                if (offset < sourceValues.length) {
                    value = sourceValues[offset++].toString();
                }
                if (value != null) {
                    value = encode ? UriComponent.encode(value, component, true) : UriComponent.recognizeEncode(value, component, true);
                    values.put(paramName, value);
                    sb.append(value);
                } else {
                    throw new IllegalArgumentException("Not found corresponding value for parameter " + paramName);
                }
            }
            lastTemplate = i + 1;
        }
        if (lastTemplate == 0) {
            sb.append(uriPart);
        } else if (lastTemplate < length) {
            sb.append(uriPart, lastTemplate, length);
        }
        return offset;
    }

    private static final class UriPatternComparator
    implements Comparator<UriPattern> {
        private UriPatternComparator() {
        }

        @Override
        public int compare(UriPattern o1, UriPattern o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.getTemplate().isEmpty() && o2.getTemplate().isEmpty()) {
                return 0;
            }
            if (o1.getTemplate().isEmpty()) {
                return 1;
            }
            if (o2.getTemplate().isEmpty()) {
                return -1;
            }
            if (o1.getNumberOfLiteralCharacters() < o2.getNumberOfLiteralCharacters()) {
                return 1;
            }
            if (o1.getNumberOfLiteralCharacters() > o2.getNumberOfLiteralCharacters()) {
                return -1;
            }
            if (o1.getParameterNames().size() < o2.getParameterNames().size()) {
                return 1;
            }
            if (o1.getParameterNames().size() > o2.getParameterNames().size()) {
                return -1;
            }
            return o1.getRegex().compareTo(o2.getRegex());
        }
    }
}

