/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobListener;
import org.everrest.core.impl.async.AsynchronousJobRejectedException;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.tools.EmptyInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AsynchronousJobPool
implements ContextResolver<AsynchronousJobPool> {
    private static final Logger LOG = LoggerFactory.getLogger(AsynchronousJobPool.class);
    private static final AtomicLong sequence = new AtomicLong(1L);
    protected final String asynchronousServicePath;
    protected final int jobTimeout;
    protected final int maxCacheSize;
    private final ExecutorService pool;
    private final Map<Long, AsynchronousJob> jobs;
    private final CopyOnWriteArrayList<AsynchronousJobListener> jobListeners;

    private static Long nextId() {
        return sequence.getAndIncrement();
    }

    public AsynchronousJobPool(EverrestConfiguration config) {
        if (config == null) {
            config = new EverrestConfiguration();
        }
        this.asynchronousServicePath = config.getAsynchronousServicePath();
        this.maxCacheSize = config.getAsynchronousCacheSize();
        this.jobTimeout = config.getAsynchronousJobTimeout();
        this.pool = this.makeExecutorService(config);
        this.jobs = Collections.synchronizedMap(new LinkedHashMap<Long, AsynchronousJob>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, AsynchronousJob> eldest) {
                AsynchronousJob job = eldest.getValue();
                if (this.size() > AsynchronousJobPool.this.maxCacheSize || job.getExpirationDate() < System.currentTimeMillis()) {
                    job.cancel();
                    return true;
                }
                return false;
            }
        });
        this.jobListeners = new CopyOnWriteArrayList();
    }

    protected ExecutorService makeExecutorService(EverrestConfiguration config) {
        int poolSize = config.getAsynchronousPoolSize();
        int queueSize = config.getAsynchronousQueueSize();
        return new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "everrest.AsynchronousJobPool" + AsynchronousJobPool.nextId());
                t.setDaemon(true);
                return t;
            }
        }, new ManyJobsPolicy(new ThreadPoolExecutor.AbortPolicy()));
    }

    public AsynchronousJobPool getContext(Class<?> type) {
        return this;
    }

    public final AsynchronousJob addJob(Object resource, ResourceMethodDescriptor resourceMethod, Object[] params) throws AsynchronousJobRejectedException {
        AsynchronousFuture job = new AsynchronousFuture(AsynchronousJobPool.nextId(), this.newCallable(resource, resourceMethod.getMethod(), params), System.currentTimeMillis() + (long)(this.jobTimeout * 60 * 1000), resourceMethod);
        job.jobUri = this.getAsynchronousJobUriBuilder(job).build(new Object[0]).toString();
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        GenericContainerRequest request = context.getContainerRequest();
        ContainerRequest copyRequest = new ContainerRequest(request.getMethod(), request.getRequestUri(), request.getBaseUri(), new EmptyInputStream(), (MultivaluedMap<String, String>)request.getRequestHeaders(), context.getSecurityContext());
        job.getContext().put("org.everrest.async.request", copyRequest);
        job.getContext().put("org.everrest.async.providers", context.getProviders());
        this.initAsynchronousJobContext(job);
        Long jobId = job.getJobId();
        this.jobs.put(jobId, job);
        try {
            this.pool.execute(job);
        }
        catch (RejectedExecutionException e) {
            this.jobs.remove(jobId);
            throw new AsynchronousJobRejectedException(e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add asynchronous job, ID " + jobId);
        }
        return job;
    }

    protected void initAsynchronousJobContext(AsynchronousJob job) {
    }

    protected UriBuilder getAsynchronousJobUriBuilder(AsynchronousJob job) {
        return UriBuilder.fromPath((String)this.asynchronousServicePath).path(Long.toString(job.getJobId()));
    }

    protected Callable<Object> newCallable(Object resource, Method method, Object[] params) {
        return new MyCallable(resource, method, params);
    }

    public AsynchronousJob getJob(Long jobId) {
        return this.jobs.get(jobId);
    }

    public AsynchronousJob removeJob(Long jobId) {
        AsynchronousJob job = this.jobs.remove(jobId);
        if (job != null && !job.isDone()) {
            job.cancel();
        }
        return job;
    }

    public List<AsynchronousJob> getAll() {
        return new ArrayList<AsynchronousJob>(this.jobs.values());
    }

    public boolean registerListener(AsynchronousJobListener listener) {
        return this.jobListeners.addIfAbsent(listener);
    }

    public boolean unregisterListener(AsynchronousJobListener listener) {
        return this.jobListeners.remove(listener);
    }

    @PreDestroy
    public void stop() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private class AsynchronousFuture
    extends FutureTask<Object>
    implements AsynchronousJob {
        private final Long jobId;
        private final long expirationDate;
        private final ResourceMethodDescriptor method;
        private final Map<String, Object> context;
        private String jobUri;

        private AsynchronousFuture(Long jobId, Callable<Object> callable, long expirationDate, ResourceMethodDescriptor method) {
            super(callable);
            this.jobId = jobId;
            this.expirationDate = expirationDate;
            this.method = method;
            this.context = new HashMap<String, Object>();
        }

        @Override
        protected void done() {
            for (AsynchronousJobListener l : AsynchronousJobPool.this.jobListeners) {
                try {
                    l.done(this);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public Long getJobId() {
            return this.jobId;
        }

        @Override
        public String getJobURI() {
            return this.jobUri;
        }

        @Override
        public long getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public ResourceMethodDescriptor getResourceMethod() {
            return this.method;
        }

        @Override
        public boolean isDone() {
            return super.isDone();
        }

        @Override
        public boolean cancel() {
            return super.cancel(true);
        }

        @Override
        public Object getResult() throws IllegalStateException {
            Object result;
            if (!this.isDone()) {
                throw new IllegalStateException("Job is not done yet. ");
            }
            try {
                result = super.get();
            }
            catch (InterruptedException e) {
                throw new InternalException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof InvocationTargetException && (cause = ((InvocationTargetException)cause).getTargetException()) instanceof WebApplicationException) {
                    throw (WebApplicationException)cause;
                }
                throw new InternalException(cause);
            }
            return result;
        }

        @Override
        public Map<String, Object> getContext() {
            return this.context;
        }
    }

    private static class MyCallable
    implements Callable<Object> {
        private final Object resource;
        private final Method method;
        private final Object[] params;

        private MyCallable(Object resource, Method method, Object[] params) {
            this.resource = resource;
            this.method = method;
            this.params = params;
        }

        @Override
        public Object call() throws Exception {
            return this.method.invoke(this.resource, this.params);
        }
    }

    public static class ManyJobsPolicy
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public ManyJobsPolicy(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.getPoolSize() >= executor.getCorePoolSize()) {
                throw new RejectedExecutionException("Can't accept new asynchronous request. Too many asynchronous jobs in progress. ");
            }
            this.delegate.rejectedExecution(r, executor);
        }
    }
}

