/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.ExtMultivaluedMap;
import org.everrest.core.util.CaselessStringWrapper;

public class CaselessMultivaluedMap<T>
implements ExtMultivaluedMap<String, T>,
Serializable {
    private static final long serialVersionUID = -4159372000926269780L;
    final ExtMultivaluedMapImpl m;
    Set<String> keys;
    Set<Map.Entry<String, List<T>>> entries;

    public CaselessMultivaluedMap() {
        this.m = new ExtMultivaluedMapImpl();
    }

    public CaselessMultivaluedMap(int capacity) {
        this.m = new ExtMultivaluedMapImpl(capacity);
    }

    public CaselessMultivaluedMap(Map<String, List<T>> m) {
        this.m = new ExtMultivaluedMapImpl(m.size());
        for (Map.Entry<String, List<T>> e : m.entrySet()) {
            this.m.put(new CaselessStringWrapper(e.getKey()), e.getValue());
        }
    }

    public void add(String key, T value) {
        this.m.add(new CaselessStringWrapper(key), value);
    }

    public void clear() {
        this.m.clear();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            return this.m.containsKey(new CaselessStringWrapper(null));
        }
        return key instanceof String && this.m.containsKey(new CaselessStringWrapper((String)key));
    }

    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    public Set<Map.Entry<String, List<T>>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    public List<T> get(Object key) {
        if (key == null) {
            return this.m.get(new CaselessStringWrapper(null));
        }
        if (!(key instanceof String)) {
            return null;
        }
        return this.m.get(new CaselessStringWrapper((String)key));
    }

    public T getFirst(String key) {
        return (T)this.m.getFirst(new CaselessStringWrapper(key));
    }

    public void addAll(String key, T ... newValues) {
        if (newValues == null) {
            throw new NullPointerException("Null array of values isn't acceptable.");
        }
        if (newValues.length == 0) {
            return;
        }
        Collections.addAll(this.m.getList(new CaselessStringWrapper(key)), newValues);
    }

    public void addAll(String key, List<T> valueList) {
        if (valueList == null) {
            throw new NullPointerException("Null list of values isn't acceptable.");
        }
        if (valueList.isEmpty()) {
            return;
        }
        this.m.getList(new CaselessStringWrapper(key)).addAll(valueList);
    }

    public void addFirst(String key, T value) {
        this.m.getList(new CaselessStringWrapper(key)).add(0, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, T> otherMap) {
        Set otherKeys;
        if (this == otherMap) {
            return true;
        }
        Set<String> myKeys = this.keySet();
        if (!myKeys.equals(otherKeys = otherMap.keySet())) {
            return false;
        }
        for (Map.Entry<String, List<T>> e : this.entrySet()) {
            List<T> myValues = e.getValue();
            List otherValues = (List)otherMap.get((Object)e.getKey());
            if (myValues == null && otherValues == null) continue;
            if (myValues != null) {
                if (myValues.size() != otherValues.size()) {
                    return false;
                }
                for (T value : myValues) {
                    if (otherValues.contains(value)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public List<T> getList(String key) {
        return this.m.getList(new CaselessStringWrapper(key));
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public Set<String> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public List<T> put(String key, List<T> value) {
        return this.m.put(new CaselessStringWrapper(key), value);
    }

    public void putAll(Map<? extends String, ? extends List<T>> m) {
        for (String string : m.keySet()) {
            List<T> values = m.get(string);
            for (T v : values) {
                this.add(string, v);
            }
        }
    }

    public void putSingle(String key, T value) {
        this.m.putSingle(new CaselessStringWrapper(key), value);
    }

    public List<T> remove(Object key) {
        if (key == null) {
            return this.m.remove(new CaselessStringWrapper(null));
        }
        if (!(key instanceof String)) {
            return null;
        }
        return this.m.remove(new CaselessStringWrapper((String)key));
    }

    public int size() {
        return this.m.size();
    }

    public Collection<List<T>> values() {
        return this.m.values();
    }

    class ExtMultivaluedMapImpl
    extends MultivaluedHashMap<CaselessStringWrapper, T>
    implements ExtMultivaluedMap<CaselessStringWrapper, T> {
        ExtMultivaluedMapImpl() {
        }

        ExtMultivaluedMapImpl(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public List<T> getList(CaselessStringWrapper key) {
            LinkedList list = this.get(key);
            if (list == null) {
                list = new LinkedList();
                this.put(key, list);
            }
            return list;
        }
    }

    class KeySet
    extends AbstractSet<String> {
        KeySet() {
        }

        @Override
        public boolean addAll(Collection<? extends String> c) {
            throw new UnsupportedOperationException("addAll");
        }

        @Override
        public void clear() {
            CaselessMultivaluedMap.this.m.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return CaselessMultivaluedMap.this.m.keySet().contains(new CaselessStringWrapper(null));
            }
            return o instanceof String && CaselessMultivaluedMap.this.m.keySet().contains(new CaselessStringWrapper((String)o));
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private Iterator<CaselessStringWrapper> i;
                {
                    this.i = CaselessMultivaluedMap.this.m.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().getString();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                return CaselessMultivaluedMap.this.m.keySet().remove(new CaselessStringWrapper(null));
            }
            return o instanceof String && CaselessMultivaluedMap.this.m.keySet().remove(new CaselessStringWrapper((String)o));
        }

        @Override
        public int size() {
            return CaselessMultivaluedMap.this.m.size();
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<String, List<T>>> {
        EntrySet() {
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, List<T>>> c) {
            throw new UnsupportedOperationException("addAll");
        }

        @Override
        public void clear() {
            CaselessMultivaluedMap.this.m.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            return !(k != null && !(k instanceof String) || v != null && !(v instanceof List) || !CaselessMultivaluedMap.this.m.entrySet().contains(new CaselessEntry(new CaselessStringWrapper((String)k), (List)v)));
        }

        @Override
        public Iterator<Map.Entry<String, List<T>>> iterator() {
            return new Iterator<Map.Entry<String, List<T>>>(){
                private Iterator<Map.Entry<CaselessStringWrapper, List<T>>> i;
                {
                    this.i = CaselessMultivaluedMap.this.m.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<String, List<T>> next() {
                    return new EntryAdapter(this.i.next());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            return !(k != null && !(k instanceof String) || v != null && !(v instanceof List) || !CaselessMultivaluedMap.this.m.entrySet().remove(new CaselessEntry(new CaselessStringWrapper((String)k), (List)v)));
        }

        @Override
        public int size() {
            return CaselessMultivaluedMap.this.m.size();
        }
    }

    static class EntryAdapter<T>
    implements Map.Entry<String, List<T>> {
        private Map.Entry<CaselessStringWrapper, List<T>> entry;

        public EntryAdapter(Map.Entry<CaselessStringWrapper, List<T>> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey().getString();
        }

        @Override
        public List<T> getValue() {
            return this.entry.getValue();
        }

        @Override
        public List<T> setValue(List<T> value) {
            return this.entry.setValue(value);
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof EntryAdapter) {
                return this.entry.equals(((EntryAdapter)o).entry);
            }
            Map.Entry entry = (Map.Entry)o;
            String myKey = this.getKey();
            Object myValue = this.getValue();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            return !(myKey == null ? entryKey != null : !myKey.equals(entryKey)) && !(myValue == null ? entryValue != null : !myValue.equals(entryValue));
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }
    }

    static class CaselessEntry<T>
    implements Map.Entry<CaselessStringWrapper, List<T>> {
        private CaselessStringWrapper key;
        private List<T> value;

        public CaselessEntry(CaselessStringWrapper key, List<T> value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public CaselessStringWrapper getKey() {
            return this.key;
        }

        @Override
        public List<T> getValue() {
            return this.value;
        }

        @Override
        public List<T> setValue(List<T> value) {
            List<T> old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            return !(this.key == null ? entryKey != null : !this.key.equals(entryKey)) && !(this.value == null ? entryValue != null : !this.value.equals(entryValue));
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + (this.key != null ? this.key.hashCode() : 0);
            hash = 31 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }
    }
}

