/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.everrest.core.util.CaselessMultivaluedMap;
import org.everrest.core.util.CaselessStringWrapper;

public class CaselessUnmodifiableMultivaluedMap<T>
extends CaselessMultivaluedMap<T> {
    private static final long serialVersionUID = -7195370974690531404L;

    public CaselessUnmodifiableMultivaluedMap() {
    }

    public CaselessUnmodifiableMultivaluedMap(int capacity) {
        super(capacity);
    }

    public CaselessUnmodifiableMultivaluedMap(Map<String, List<T>> m) {
        this(m.size());
        for (Map.Entry<String, List<T>> e : m.entrySet()) {
            this.m.put(new CaselessStringWrapper(e.getKey()), Collections.unmodifiableList(e.getValue()));
        }
    }

    @Override
    public void add(String key, T value) {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear");
    }

    @Override
    public Set<Map.Entry<String, List<T>>> entrySet() {
        if (this.entries == null) {
            this.entries = new ReadOnlyEntrySet();
        }
        return this.entries;
    }

    @Override
    public List<T> get(Object key) {
        Object list = super.get(key);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return null;
    }

    @Override
    public List<T> getList(String key) {
        return Collections.unmodifiableList(super.getList(key));
    }

    @Override
    public Set<String> keySet() {
        if (this.keys == null) {
            this.keys = new ReadOnlyKeySet();
        }
        return this.keys;
    }

    @Override
    public List<T> put(String key, List<T> value) {
        throw new UnsupportedOperationException("put");
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<T>> m) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public void putSingle(String key, T value) {
        throw new UnsupportedOperationException("putSingle");
    }

    @Override
    public List<T> remove(Object key) {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public void addAll(String key, T ... newValues) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public void addAll(String key, List<T> valueList) {
        throw new UnsupportedOperationException("addAll");
    }

    @Override
    public void addFirst(String key, T value) {
        throw new UnsupportedOperationException("addFirst");
    }

    @Override
    public Collection<List<T>> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    class ReadOnlyKeySet
    extends CaselessMultivaluedMap.KeySet {
        ReadOnlyKeySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear");
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private Iterator<CaselessStringWrapper> i;
                {
                    this.i = CaselessUnmodifiableMultivaluedMap.this.m.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().getString();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("removeAll");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll");
        }
    }

    class ReadOnlyEntrySet
    extends CaselessMultivaluedMap.EntrySet {
        ReadOnlyEntrySet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("clear");
        }

        @Override
        public Iterator<Map.Entry<String, List<T>>> iterator() {
            return new Iterator<Map.Entry<String, List<T>>>(){
                private Iterator<Map.Entry<CaselessStringWrapper, List<T>>> i;
                {
                    this.i = CaselessUnmodifiableMultivaluedMap.this.m.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<String, List<T>> next() {
                    return new ReadOnlyEntryAdapter(this.i.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("retainAll");
        }
    }

    static class ReadOnlyEntryAdapter<T>
    extends CaselessMultivaluedMap.EntryAdapter<T> {
        public ReadOnlyEntryAdapter(Map.Entry<CaselessStringWrapper, List<T>> entry) {
            super(entry);
        }

        @Override
        public List<T> setValue(List<T> value) {
            throw new UnsupportedOperationException("setValue");
        }
    }
}

