/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.ExtMultivaluedMap;
import org.everrest.core.uri.UriPattern;

public class UriPatternMap<V>
extends ConcurrentHashMap<UriPattern, List<V>>
implements ExtMultivaluedMap<UriPattern, V> {
    private static final long serialVersionUID = 8248982446381545144L;

    @Override
    public List<V> getList(UriPattern uriPattern) {
        CopyOnWriteArrayList newList;
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.get(uriPattern);
        if (list == null && (list = (List)this.putIfAbsent(uriPattern, newList = new CopyOnWriteArrayList())) == null) {
            list = newList;
        }
        return list;
    }

    public void add(UriPattern uriPattern, V value) {
        if (value == null) {
            return;
        }
        List<V> list = this.getList(uriPattern);
        list.add(value);
    }

    public V getFirst(UriPattern uriPattern) {
        List<V> list = this.getList(uriPattern);
        return list != null && list.size() > 0 ? (V)list.get(0) : null;
    }

    public void addAll(UriPattern key, V ... newValues) {
        if (newValues == null) {
            throw new NullPointerException("Null array of values isn't acceptable.");
        }
        if (newValues.length == 0) {
            return;
        }
        Collections.addAll(this.getList(key), newValues);
    }

    public void addAll(UriPattern key, List<V> valueList) {
        if (valueList == null) {
            throw new NullPointerException("Null list of values isn't acceptable.");
        }
        if (valueList.isEmpty()) {
            return;
        }
        this.getList(key).addAll(valueList);
    }

    public void addFirst(UriPattern key, V value) {
        this.getList(key).add(0, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<UriPattern, V> otherMap) {
        Set otherKeys;
        if (this == otherMap) {
            return true;
        }
        Set myKeys = this.keySet();
        if (!myKeys.equals(otherKeys = otherMap.keySet())) {
            return false;
        }
        for (Map.Entry e : this.entrySet()) {
            List myValues = (List)e.getValue();
            List otherValues = (List)otherMap.get(e.getKey());
            if (myValues == null && otherValues == null) continue;
            if (myValues != null) {
                if (myValues.size() != otherValues.size()) {
                    return false;
                }
                for (Object value : myValues) {
                    if (otherValues.contains(value)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public void putSingle(UriPattern uriPattern, V value) {
        if (value == null) {
            this.remove(uriPattern);
            return;
        }
        List<V> list = this.getList(uriPattern);
        list.clear();
        list.add(value);
    }
}

