/*******************************************************************************
 * Copyright (c) 2012-2016 Codenvy, S.A.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Codenvy, S.A. - initial API and implementation
 *******************************************************************************/
package org.everrest.core.impl.method;

import org.everrest.core.ApplicationContext;

/**
 * @param <T>
 *         on of JAX-RS annotation that used for method parameters
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id$
 */
public abstract class ParameterResolver<T> {
    /**
     * Create object which will be passed in resource method or locator. Object
     * is instance of {@link MethodParameterImpl#getParameterClass()}.
     *
     * @param parameter
     *         See {@link org.everrest.core.Parameter}
     * @param context
     *         See {@link ApplicationContext}
     * @return newly created instance of class
     * {@link MethodParameterImpl#getParameterClass()}
     * @throws Exception
     *         if any errors occurs
     */
    public abstract Object resolve(org.everrest.core.Parameter parameter, ApplicationContext context) throws Exception;
}
