/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.Filter;
import org.everrest.core.ObjectFactory;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.impl.EverrestApplication;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.method.MethodInvokerFilter;

public class ApplicationPublisher {
    protected final ResourceBinder resources;
    protected final ProviderBinder providers;

    public ApplicationPublisher(ResourceBinder resources, ProviderBinder providers) {
        this.resources = resources;
        this.providers = providers;
    }

    public void publish(Application application) {
        LinkedHashSet classes = new LinkedHashSet();
        Set appClasses = application.getClasses();
        if (appClasses != null) {
            classes.addAll(appClasses);
        }
        if (application instanceof EverrestApplication) {
            EverrestApplication everrest = (EverrestApplication)application;
            for (Map.Entry<String, Class<?>> entry : everrest.getResourceClasses().entrySet()) {
                Class<?> clazz = entry.getValue();
                this.addResource(entry.getKey(), clazz);
                classes.remove(clazz);
            }
            for (Map.Entry<String, Object> entry : everrest.getResourceSingletons().entrySet()) {
                this.addResource(entry.getKey(), entry.getValue());
            }
            for (ObjectFactory objectFactory : everrest.getFactories()) {
                this.addFactory(objectFactory);
                classes.remove(objectFactory.getObjectModel().getObjectClass());
            }
        }
        for (Class clazz : classes) {
            this.addPerRequest(clazz);
        }
        Set singletons = application.getSingletons();
        if (singletons != null) {
            for (Map.Entry<String, Object> entry : singletons) {
                this.addSingleton(entry);
            }
        }
    }

    private void addResource(String uriPattern, Class<?> resourceClass) {
        this.resources.addResource(uriPattern, resourceClass, null);
    }

    private void addResource(String uriPattern, Object resource) {
        this.resources.addResource(uriPattern, resource, null);
    }

    private void addSingleton(Object instance) {
        Class<?> clazz = instance.getClass();
        if (clazz.getAnnotation(Provider.class) != null) {
            if (instance instanceof ContextResolver) {
                this.providers.addContextResolver((ContextResolver)instance);
            }
            if (instance instanceof ExceptionMapper) {
                this.providers.addExceptionMapper((ExceptionMapper)instance);
            }
            if (instance instanceof MessageBodyReader) {
                this.providers.addMessageBodyReader((MessageBodyReader)instance);
            }
            if (instance instanceof MessageBodyWriter) {
                this.providers.addMessageBodyWriter((MessageBodyWriter)instance);
            }
        } else if (clazz.getAnnotation(Filter.class) != null) {
            if (instance instanceof MethodInvokerFilter) {
                this.providers.addMethodInvokerFilter((MethodInvokerFilter)instance);
            }
            if (instance instanceof RequestFilter) {
                this.providers.addRequestFilter((RequestFilter)instance);
            }
            if (instance instanceof ResponseFilter) {
                this.providers.addResponseFilter((ResponseFilter)instance);
            }
        } else if (clazz.getAnnotation(Path.class) != null) {
            this.resources.addResource(instance, null);
        }
    }

    private void addPerRequest(Class clazz) {
        if (clazz.getAnnotation(Provider.class) != null) {
            if (ContextResolver.class.isAssignableFrom(clazz)) {
                this.providers.addContextResolver(clazz);
            }
            if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                this.providers.addExceptionMapper(clazz);
            }
            if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                this.providers.addMessageBodyReader(clazz);
            }
            if (MessageBodyWriter.class.isAssignableFrom(clazz)) {
                this.providers.addMessageBodyWriter(clazz);
            }
        } else if (clazz.getAnnotation(Filter.class) != null) {
            if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                this.providers.addMethodInvokerFilter(clazz);
            }
            if (RequestFilter.class.isAssignableFrom(clazz)) {
                this.providers.addRequestFilter(clazz);
            }
            if (ResponseFilter.class.isAssignableFrom(clazz)) {
                this.providers.addResponseFilter(clazz);
            }
        } else if (clazz.getAnnotation(Path.class) != null) {
            this.resources.addResource(clazz, null);
        }
    }

    private void addFactory(ObjectFactory factory) {
        Class<?> clazz = factory.getObjectModel().getObjectClass();
        if (clazz.getAnnotation(Provider.class) != null) {
            if (ContextResolver.class.isAssignableFrom(clazz)) {
                this.providers.addContextResolver(factory);
            }
            if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                this.providers.addExceptionMapper(factory);
            }
            if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                this.providers.addMessageBodyReader(factory);
            }
            if (MessageBodyWriter.class.isAssignableFrom(clazz)) {
                this.providers.addMessageBodyWriter(factory);
            }
        } else if (clazz.getAnnotation(Filter.class) != null) {
            if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                this.providers.addMethodInvokerFilter(factory);
            }
            if (RequestFilter.class.isAssignableFrom(clazz)) {
                this.providers.addRequestFilter(factory);
            }
            if (ResponseFilter.class.isAssignableFrom(clazz)) {
                this.providers.addResponseFilter(factory);
            }
        } else if (clazz.getAnnotation(Path.class) != null) {
            this.resources.addResource(factory);
        }
    }
}

