/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.everrest.core.ApplicationContext;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.Lifecycle;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ResourceBinder;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.HelperCache;
import org.everrest.core.impl.LifecycleComponent;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.header.HeaderHelper;
import org.everrest.core.impl.header.MediaTypeHelper;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.method.MethodInvoker;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.resource.ResourceMethodMap;
import org.everrest.core.resource.SubResourceLocatorDescriptor;
import org.everrest.core.resource.SubResourceLocatorMap;
import org.everrest.core.resource.SubResourceMethodDescriptor;
import org.everrest.core.resource.SubResourceMethodMap;
import org.everrest.core.uri.UriPattern;
import org.everrest.core.util.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RequestDispatcher.class);
    protected final ResourceBinder resourceBinder;
    private final HelperCache<Class<?>, AbstractResourceDescriptor> locatorDescriptorCache = new HelperCache(60000L, 50);

    public RequestDispatcher(ResourceBinder resourceBinder) {
        this.resourceBinder = resourceBinder;
    }

    public void dispatch(GenericContainerRequest request, GenericContainerResponse response) {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        String requestPath = context.getPath(false);
        List<String> parameterValues = context.getParameterValues();
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = this.getRootResource(parameterValues, requestPath);
        String newRequestPath = RequestDispatcher.getPathTail(parameterValues);
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(resourceFactory.getObjectModel().getUriPattern().getParameterNames());
        Object resource = resourceFactory.getInstance(context);
        this.dispatch(request, response, context, resourceFactory, resource, newRequestPath);
    }

    protected static String getPathTail(List<String> parameterValues) {
        int i = parameterValues.size() - 1;
        return parameterValues.get(i) != null ? parameterValues.get(i) : "";
    }

    protected void dispatch(GenericContainerRequest request, GenericContainerResponse response, ApplicationContext context, ObjectFactory<AbstractResourceDescriptor> resourceFactory, Object resource, String requestPath) {
        List<String> parameterValues = context.getParameterValues();
        int len = parameterValues.size();
        ResourceMethodMap<ResourceMethodDescriptor> rmm = resourceFactory.getObjectModel().getResourceMethods();
        if ((parameterValues.get(len - 1) == null || "/".equals(parameterValues.get(len - 1))) && rmm.size() > 0) {
            ArrayList methods = new ArrayList();
            boolean match = this.processResourceMethod(rmm, request, response, methods);
            if (match) {
                if (Tracer.isTracingEnabled()) {
                    Tracer.trace("Matched resource method for method \"" + request.getMethod() + "\", media type \"" + request.getMediaType() + "\" = (" + ((ResourceMethodDescriptor)methods.get(0)).getMethod() + ")");
                }
                this.invokeResourceMethod((ResourceMethodDescriptor)methods.get(0), resource, context, request, response);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Not found resource method for method " + request.getMethod());
            }
        } else {
            ArrayList<SubResourceLocatorDescriptor> locators;
            boolean acceptableLocators;
            SubResourceMethodMap srmm = resourceFactory.getObjectModel().getSubResourceMethods();
            SubResourceLocatorMap srlm = resourceFactory.getObjectModel().getSubResourceLocators();
            ArrayList<SubResourceMethodDescriptor> methods = new ArrayList<SubResourceMethodDescriptor>();
            boolean match = this.processSubResourceMethod(srmm, requestPath, request, response, parameterValues, methods);
            if (match && Tracer.isTracingEnabled()) {
                Tracer.trace("Matched sub-resource method for method \"" + request.getMethod() + "\", path \"" + requestPath + "\", media type \"" + request.getMediaType() + "\" = (" + ((SubResourceMethodDescriptor)methods.get(0)).getMethod() + ")");
            }
            if ((acceptableLocators = this.processSubResourceLocator(srlm, requestPath, parameterValues, locators = new ArrayList<SubResourceLocatorDescriptor>())) && Tracer.isTracingEnabled()) {
                Tracer.trace("Matched sub-resource locator for path \"" + requestPath + "\", media type \"" + request.getMediaType() + "\" = (" + ((SubResourceLocatorDescriptor)locators.get(0)).getMethod() + ")");
            }
            if (match || acceptableLocators) {
                response.setResponse(null);
                if (match && (!acceptableLocators || this.compareSubResources((SubResourceMethodDescriptor)methods.get(0), (SubResourceLocatorDescriptor)locators.get(0)) < 0)) {
                    if (Tracer.isTracingEnabled()) {
                        Tracer.trace("Sub-resource method (" + ((SubResourceMethodDescriptor)methods.get(0)).getMethod() + ") selected. ");
                    }
                    this.invokeSubResourceMethod(requestPath, (SubResourceMethodDescriptor)methods.get(0), resource, context, request, response);
                } else {
                    if (Tracer.isTracingEnabled()) {
                        Tracer.trace("Sub-resource locator (" + ((SubResourceLocatorDescriptor)locators.get(0)).getMethod() + ") selected. ");
                    }
                    this.invokeSubResourceLocator(requestPath, (SubResourceLocatorDescriptor)locators.get(0), resource, context, request, response);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Not found sub-resource methods nor sub-resource locators for path " + requestPath + " and method " + request.getMethod());
            }
        }
    }

    private void invokeResourceMethod(ResourceMethodDescriptor rmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        this.doInvokeResource(rmd, resource, context, request, response);
    }

    private void invokeSubResourceMethod(String requestPath, SubResourceMethodDescriptor srmd, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        context.addMatchedResource(resource);
        context.addMatchedURI(requestPath);
        context.setParameterNames(srmd.getUriPattern().getParameterNames());
        this.doInvokeResource(srmd, resource, context, request, response);
    }

    private void doInvokeResource(ResourceMethodDescriptor method, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        MethodInvoker invoker = context.getMethodInvoker(method);
        Object o = invoker.invokeMethod(resource, method, context);
        this.processResponse(o, request, response, method.produces(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSubResourceLocator(String requestPath, SubResourceLocatorDescriptor srld, Object resource, ApplicationContext context, GenericContainerRequest request, GenericContainerResponse response) {
        AbstractResourceDescriptor descriptor;
        context.addMatchedResource(resource);
        String newRequestPath = RequestDispatcher.getPathTail(context.getParameterValues());
        context.addMatchedURI(requestPath.substring(0, requestPath.lastIndexOf(newRequestPath)));
        context.setParameterNames(srld.getUriPattern().getParameterNames());
        MethodInvoker invoker = context.getMethodInvoker(srld);
        resource = invoker.invokeMethod(resource, srld, context);
        HelperCache<Class<?>, AbstractResourceDescriptor> helperCache = this.locatorDescriptorCache;
        synchronized (helperCache) {
            descriptor = this.locatorDescriptorCache.get(resource.getClass());
            if (descriptor == null) {
                descriptor = new AbstractResourceDescriptorImpl(resource);
                this.locatorDescriptorCache.put(resource.getClass(), descriptor);
            }
        }
        SingletonObjectFactory<AbstractResourceDescriptor> locResource = new SingletonObjectFactory<AbstractResourceDescriptor>(descriptor, resource);
        if (context instanceof Lifecycle) {
            LinkedList<LifecycleComponent> perRequest = (LinkedList<LifecycleComponent>)context.getAttributes().get("org.everrest.lifecycle.PerRequest");
            if (perRequest == null) {
                perRequest = new LinkedList<LifecycleComponent>();
                context.getAttributes().put("org.everrest.lifecycle.PerRequest", perRequest);
            }
            perRequest.add(new LifecycleComponent(resource));
        }
        if (Tracer.isTracingEnabled()) {
            Tracer.trace("Sub-resource for request path \"" + newRequestPath + "\" = (" + resource + ")");
        }
        this.dispatch(request, response, context, locResource, resource, newRequestPath);
    }

    private int compareSubResources(SubResourceMethodDescriptor srmd, SubResourceLocatorDescriptor srld) {
        int r = UriPattern.URIPATTERN_COMPARATOR.compare(srmd.getUriPattern(), srld.getUriPattern());
        return r == 0 ? -1 : r;
    }

    private void processResponse(Object o, GenericContainerRequest request, GenericContainerResponse response, List<MediaType> produces, ApplicationContext context) {
        if (response.getResponse() != null) {
            return;
        }
        if (o == null || o.getClass() == Void.TYPE || o.getClass() == Void.class) {
            response.setResponse(Response.noContent().build());
        } else if (o instanceof AsynchronousJob) {
            String internalJobUri = ((AsynchronousJob)o).getJobURI();
            String externalJobUri = context.getBaseUriBuilder().path(internalJobUri).build(new Object[0]).toString();
            response.setResponse(Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)externalJobUri).entity((Object)externalJobUri).type("text/plain").build());
        } else {
            MediaType contentType = request.getAcceptableMediaType(produces);
            if (Response.class.isAssignableFrom(o.getClass())) {
                Response r = (Response)o;
                if (r.getMetadata().getFirst((Object)"Content-Type") == null && r.getEntity() != null) {
                    r.getMetadata().putSingle((Object)"Content-Type", (Object)contentType);
                }
                response.setResponse(r);
            } else if (GenericEntity.class.isAssignableFrom(o.getClass())) {
                response.setResponse(Response.ok((Object)o, (MediaType)contentType).build());
            } else {
                response.setResponse(Response.ok((Object)o, (MediaType)contentType).build());
            }
        }
    }

    private <T extends ResourceMethodDescriptor> boolean processResourceMethod(ResourceMethodMap<T> rmm, GenericContainerRequest request, GenericContainerResponse response, List<T> methods) {
        int n;
        String method = request.getMethod();
        List<T> rmds = rmm.getList(method);
        if (rmds == null || rmds.size() == 0) {
            response.setResponse(Response.status((int)405).header("Allow", (Object)HeaderHelper.convertToString(rmm.getAllow())).entity((Object)(method + " method is not allowed for resource " + ApplicationContextImpl.getCurrent().getPath())).type("text/plain").build());
            return false;
        }
        MediaType contentType = request.getMediaType();
        if (contentType == null) {
            methods.addAll(rmds);
        } else {
            for (ResourceMethodDescriptor rmd : rmds) {
                if (!MediaTypeHelper.isConsume(rmd.consumes(), contentType)) continue;
                methods.add(rmd);
            }
        }
        if (methods.isEmpty()) {
            response.setResponse(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)("Media type " + contentType + " is not supported.")).type("text/plain").build());
            return false;
        }
        List acceptable = request.getAcceptableMediaTypes();
        float previousQValue = 0.0f;
        int p = 0;
        ListIterator<T> i = methods.listIterator();
        while (i.hasNext()) {
            n = i.nextIndex();
            ResourceMethodDescriptor rmd = (ResourceMethodDescriptor)i.next();
            float qValue = MediaTypeHelper.processQuality(acceptable, rmd.produces());
            if (qValue > previousQValue) {
                previousQValue = qValue;
                p = n;
                continue;
            }
            i.remove();
        }
        if (!methods.isEmpty()) {
            if (methods.size() > 1) {
                n = 0;
                i = methods.listIterator();
                while (i.hasNext()) {
                    i.next();
                    if (n == p) break;
                    i.remove();
                    ++n;
                }
            }
            return true;
        }
        response.setResponse(Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)"Not Acceptable").type("text/plain").build());
        return false;
    }

    private boolean processSubResourceMethod(SubResourceMethodMap srmm, String requestedPath, GenericContainerRequest request, GenericContainerResponse response, List<String> capturingValues, List<SubResourceMethodDescriptor> methods) {
        ResourceMethodMap rmm = null;
        for (Map.Entry e : srmm.entrySet()) {
            int len;
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues) || capturingValues.get((len = capturingValues.size()) - 1) != null && !"/".equals(capturingValues.get(len - 1))) continue;
            rmm = (ResourceMethodMap)e.getValue();
            break;
        }
        if (rmm == null) {
            response.setResponse(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("There is no any resources matched to request path " + requestedPath)).type("text/plain").build());
            return false;
        }
        ArrayList l = new ArrayList();
        boolean match = this.processResourceMethod(rmm, request, response, l);
        if (match) {
            for (SubResourceMethodDescriptor aL : l) {
                methods.add(aL);
            }
        }
        return match;
    }

    private boolean processSubResourceLocator(SubResourceLocatorMap srlm, String requestedPath, List<String> capturingValues, List<SubResourceLocatorDescriptor> locators) {
        for (Map.Entry e : srlm.entrySet()) {
            if (!((UriPattern)e.getKey()).match(requestedPath, capturingValues)) continue;
            locators.add((SubResourceLocatorDescriptor)e.getValue());
        }
        return !locators.isEmpty();
    }

    protected ObjectFactory<AbstractResourceDescriptor> getRootResource(List<String> parameterValues, String requestPath) {
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = this.resourceBinder.getMatchedResource(requestPath, parameterValues);
        if (resourceFactory == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Root resource not found for " + requestPath);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("There is no any resources matched to request path " + requestPath)).type("text/plain").build());
        }
        if (Tracer.isTracingEnabled()) {
            AbstractResourceDescriptor model = resourceFactory.getObjectModel();
            Tracer.trace("Matched root resource for request path \"" + requestPath + "\" = (@Path \"" + model.getPathValue().getPath() + "\", " + model.getObjectClass() + ")");
        }
        return resourceFactory;
    }
}

