/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.LinkedHashMap;
import java.util.Map;

public class HelperCache<K, V> {
    private final int cacheSize;
    private final long expiredAfter;
    private final int queryCountBeforeCleanup;
    private final Map<K, MyEntry<V>> map;
    private int queryCount;

    public HelperCache(long expiredAfter, int cacheSize) {
        this.expiredAfter = expiredAfter;
        this.cacheSize = cacheSize;
        this.queryCountBeforeCleanup = 500;
        this.map = new LinkedHashMap<K, MyEntry<V>>(this.cacheSize + 1, 1.1f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, MyEntry<V>> eldest) {
                return this.size() > HelperCache.this.cacheSize;
            }
        };
    }

    public V get(K key) {
        MyEntry<V> myEntry;
        if (++this.queryCount >= this.queryCountBeforeCleanup) {
            this.cleanup();
        }
        if ((myEntry = this.map.get(key)) != null) {
            myEntry.lastAccess = System.currentTimeMillis();
            return myEntry.value;
        }
        return null;
    }

    public void put(K key, V value) {
        MyEntry<V> myEntry;
        if (++this.queryCount >= this.queryCountBeforeCleanup) {
            this.cleanup();
        }
        if ((myEntry = this.map.get(key)) != null) {
            myEntry.lastAccess = System.currentTimeMillis();
            myEntry.value = value;
        } else {
            this.map.put(key, new MyEntry<V>(value, System.currentTimeMillis()));
        }
    }

    private void cleanup() {
        Object[] keys = this.map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            long inCache;
            Object key = keys[i];
            MyEntry<V> myEntry = this.map.get(key);
            if (myEntry == null || (inCache = System.currentTimeMillis() - myEntry.lastAccess) >= 0L && inCache <= this.expiredAfter) continue;
            this.map.remove(key);
        }
        this.queryCount = 0;
    }

    private static class MyEntry<V> {
        V value;
        long lastAccess;

        MyEntry(V value, long lastAccess) {
            this.value = value;
            this.lastAccess = lastAccess;
        }
    }
}

