/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.everrest.core.ApplicationContext;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.ObjectFactory;
import org.everrest.core.RequestFilter;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResponseFilter;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.tools.ErrorPages;
import org.everrest.core.util.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandlerImpl
implements RequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHandlerImpl.class);
    private final RequestDispatcher dispatcher;

    public RequestHandlerImpl(RequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    public void handleRequest(GenericContainerRequest request, GenericContainerResponse response) throws UnhandledException, IOException {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        try {
            Object jaxrsHeader;
            for (ObjectFactory<FilterDescriptor> objectFactory : context.getProviders().getRequestFilters(context.getPath())) {
                ((RequestFilter)objectFactory.getInstance(context)).doFilter(request);
            }
            this.dispatcher.dispatch(request, response);
            if (response.getHttpHeaders().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(response.getStatus())) != null) {
                response.getHttpHeaders().putSingle((Object)"JAXRS-Body-Provided", jaxrsHeader);
            }
            for (ObjectFactory objectFactory : context.getProviders().getResponseFilters(context.getPath())) {
                ((ResponseFilter)objectFactory.getInstance(context)).doFilter(response);
            }
        }
        catch (Exception e) {
            ErrorPages errorPages = (ErrorPages)EnvironmentContext.getCurrent().get(ErrorPages.class);
            if (e instanceof WebApplicationException) {
                Response errorResponse = ((WebApplicationException)e).getResponse();
                int errorStatus = errorResponse.getStatus();
                Throwable cause = e.getCause();
                if (errorStatus < 500) {
                    if (LOG.isDebugEnabled() && cause != null) {
                        LOG.debug("WebApplicationException occurs.", cause);
                    }
                } else if (cause != null) {
                    LOG.error("WebApplicationException occurs.", cause);
                }
                if (Tracer.isTracingEnabled()) {
                    Tracer.trace("WebApplicationException occurs, cause = (" + cause + ")");
                }
                if (errorPages != null && (errorPages.hasErrorPage(errorStatus) || cause != null && errorPages.hasErrorPage(cause.getClass().getName()))) {
                    throw new UnhandledException(e.getCause());
                }
                if (errorResponse.hasEntity()) {
                    String jaxrsHeader;
                    if (errorResponse.getMetadata().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(errorStatus)) != null) {
                        errorResponse.getMetadata().putSingle((Object)"JAXRS-Body-Provided", (Object)jaxrsHeader);
                    }
                } else {
                    ExceptionMapper<WebApplicationException> exceptionMapper = context.getProviders().getExceptionMapper(WebApplicationException.class);
                    if (exceptionMapper != null) {
                        if (Tracer.isTracingEnabled()) {
                            Tracer.trace("Found ExceptionMapper for WebApplicationException = (" + exceptionMapper + ")");
                        }
                        errorResponse = exceptionMapper.toResponse((Throwable)e);
                    } else if (cause != null) {
                        errorResponse = this.createErrorResponse(errorStatus, cause.toString());
                    } else if (e.getMessage() != null) {
                        errorResponse = this.createErrorResponse(errorStatus, e.getMessage());
                    }
                }
                response.setResponse(errorResponse);
            }
            if (e instanceof InternalException) {
                Throwable cause = e.getCause();
                if (Tracer.isTracingEnabled()) {
                    Tracer.trace("InternalException occurs, cause = (" + cause + ")");
                }
                if (errorPages != null && errorPages.hasErrorPage(cause.getClass().getName())) {
                    throw new UnhandledException(e.getCause());
                }
                Class<?> causeClazz = cause.getClass();
                ExceptionMapper<?> exceptionMapper = context.getProviders().getExceptionMapper(causeClazz);
                while (causeClazz != null && exceptionMapper == null) {
                    exceptionMapper = context.getProviders().getExceptionMapper(causeClazz);
                    if (exceptionMapper != null) continue;
                    causeClazz = causeClazz.getSuperclass();
                }
                if (exceptionMapper != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("InternalException occurs.", cause);
                    }
                    if (Tracer.isTracingEnabled()) {
                        Tracer.trace("Found ExceptionMapper for " + cause.getClass() + " = (" + exceptionMapper + ")");
                    }
                    response.setResponse(exceptionMapper.toResponse(cause));
                }
                LOG.error("InternalException occurs.", cause);
                throw new UnhandledException(e.getCause());
            }
            throw new UnhandledException(e);
        }
        response.writeResponse();
    }

    private Response createErrorResponse(int status, String message) {
        Response.ResponseBuilder responseBuilder = Response.status((int)status);
        responseBuilder.entity((Object)message).type("text/plain");
        String jaxrsHeader = this.getJaxrsHeader(status);
        if (jaxrsHeader != null) {
            responseBuilder.header("JAXRS-Body-Provided", (Object)jaxrsHeader);
        }
        return responseBuilder.build();
    }

    private String getJaxrsHeader(int status) {
        if (status >= 400) {
            return "Error-Message";
        }
        return null;
    }
}

