/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.tools;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.ContainerResponseWriter;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.InputHeadersMap;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.tools.DummyContainerResponseWriter;
import org.everrest.core.tools.EmptyInputStream;
import org.everrest.core.tools.SimpleSecurityContext;

public class ResourceLauncher {
    private final EverrestProcessor processor;

    public ResourceLauncher(EverrestProcessor processor) {
        this.processor = processor;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, ContainerResponseWriter writer, EnvironmentContext env) throws Exception {
        SecurityContext securityContext;
        InputStream in;
        if (baseURI == null) {
            baseURI = "";
        }
        if (requestURI == null) {
            requestURI = "/";
        }
        if (baseURI.isEmpty() && !requestURI.startsWith("/")) {
            requestURI = '/' + requestURI;
        }
        if (headers == null) {
            headers = new MultivaluedMapImpl();
        }
        if (data != null) {
            in = new ByteArrayInputStream(data);
            headers.put("Content-Length", Arrays.asList(Integer.toString(data.length)));
        } else {
            in = new EmptyInputStream();
            headers.put("Content-Length", Arrays.asList("0"));
        }
        if (env == null) {
            env = new EnvironmentContext();
        }
        if (writer == null) {
            writer = new DummyContainerResponseWriter();
        }
        if ((securityContext = (SecurityContext)env.get(SecurityContext.class)) == null) {
            securityContext = new SimpleSecurityContext(false);
        }
        ContainerRequest request = new ContainerRequest(method, new URI(requestURI), new URI(baseURI), in, new InputHeadersMap((Map<String, List<String>>)headers), securityContext);
        ContainerResponse response = new ContainerResponse(writer);
        this.processor.process(request, response, env);
        return response;
    }

    public ContainerResponse service(String method, String requestURI, String baseURI, Map<String, List<String>> headers, byte[] data, EnvironmentContext env) throws Exception {
        return this.service(method, requestURI, baseURI, headers, data, new DummyContainerResponseWriter(), env);
    }
}

