/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.HashMap;
import java.util.Map;

public class EverrestConfiguration {
    public static final String EVERREST_HTTP_METHOD_OVERRIDE = "org.everrest.http.method.override";
    public static final String EVERREST_NORMALIZE_URI = "org.everrest.normalize.uri";
    public static final String EVERREST_CHECK_SECURITY = "org.everrest.security";
    public static final String EVERREST_ASYNCHRONOUS = "org.everrest.asynchronous";
    public static final String EVERREST_ASYNCHRONOUS_SERVICE_PATH = "org.everrest.asynchronous.service.path";
    public static final String EVERREST_ASYNCHRONOUS_POOL_SIZE = "org.everrest.asynchronous.pool.size";
    public static final String EVERREST_ASYNCHRONOUS_QUEUE_SIZE = "org.everrest.asynchronous.queue.size";
    public static final String EVERREST_ASYNCHRONOUS_CACHE_SIZE = "org.everrest.asynchronous.cache.size";
    public static final String EVERREST_ASYNCHRONOUS_JOB_TIMEOUT = "org.everrest.asynchronous.job.timeout";
    public static final String METHOD_INVOKER_DECORATOR_FACTORY = "org.everrest.core.impl.method.MethodInvokerDecoratorFactory";
    public static final String EVERREST_MAX_BUFFER_SIZE = "org.everrest.max.buffer.size";
    public static final boolean defaultCheckSecurity = true;
    public static final boolean defaultHttpMethodOverride = true;
    public static final boolean defaultNormalizeUri = false;
    public static final boolean defaultAsynchronousSupported = true;
    public static final int defaultAsynchronousPoolSize = 10;
    public static final String defaultAsynchronousServicePath = "/async";
    public static final int defaultAsynchronousQueueSize = 100;
    public static final int defaultAsynchronousCacheSize = 512;
    public static final int defaultAsynchronousJobTimeout = 60;
    public static final int defaultMaxBufferSize = 204800;
    protected final Map<String, String> properties;

    public EverrestConfiguration() {
        this.properties = new HashMap<String, String>();
    }

    public EverrestConfiguration(EverrestConfiguration other) {
        this.properties = new HashMap<String, String>(other.properties);
    }

    public boolean isCheckSecurity() {
        return this.getBooleanProperty(EVERREST_CHECK_SECURITY, true);
    }

    public void setCheckSecurity(boolean checkSecurity) {
        this.properties.put(EVERREST_CHECK_SECURITY, Boolean.toString(checkSecurity));
    }

    public boolean isHttpMethodOverride() {
        return this.getBooleanProperty(EVERREST_HTTP_METHOD_OVERRIDE, true);
    }

    public void setHttpMethodOverride(boolean httpMethodOverride) {
        this.properties.put(EVERREST_HTTP_METHOD_OVERRIDE, Boolean.toString(httpMethodOverride));
    }

    public boolean isNormalizeUri() {
        return this.getBooleanProperty(EVERREST_NORMALIZE_URI, false);
    }

    public void setNormalizeUri(boolean normalizeUri) {
        this.properties.put(EVERREST_NORMALIZE_URI, Boolean.toString(normalizeUri));
    }

    public boolean isAsynchronousSupported() {
        return this.getBooleanProperty(EVERREST_ASYNCHRONOUS, true);
    }

    public void setAsynchronousSupported(boolean asynchronousSupported) {
        this.properties.put(EVERREST_ASYNCHRONOUS, Boolean.toString(asynchronousSupported));
    }

    public String getAsynchronousServicePath() {
        return this.getProperty(EVERREST_ASYNCHRONOUS_SERVICE_PATH, defaultAsynchronousServicePath);
    }

    public void setAsynchronousServicePath(String servicePath) {
        this.properties.put(EVERREST_ASYNCHRONOUS_SERVICE_PATH, servicePath);
    }

    public int getAsynchronousPoolSize() {
        return this.getNumberProperty(EVERREST_ASYNCHRONOUS_POOL_SIZE, 10.0).intValue();
    }

    public void setAsynchronousPoolSize(int asynchronousPoolSize) {
        this.properties.put(EVERREST_ASYNCHRONOUS_POOL_SIZE, Integer.toString(asynchronousPoolSize));
    }

    public int getAsynchronousQueueSize() {
        return this.getNumberProperty(EVERREST_ASYNCHRONOUS_QUEUE_SIZE, 100.0).intValue();
    }

    public void setAsynchronousQueueSize(int asynchronousQueueSize) {
        this.properties.put(EVERREST_ASYNCHRONOUS_QUEUE_SIZE, Integer.toString(asynchronousQueueSize));
    }

    public int getAsynchronousCacheSize() {
        return this.getNumberProperty(EVERREST_ASYNCHRONOUS_CACHE_SIZE, 512.0).intValue();
    }

    public void setAsynchronousCacheSize(int asynchronousCacheSize) {
        this.properties.put(EVERREST_ASYNCHRONOUS_CACHE_SIZE, Integer.toString(asynchronousCacheSize));
    }

    public int getAsynchronousJobTimeout() {
        return this.getNumberProperty(EVERREST_ASYNCHRONOUS_JOB_TIMEOUT, 60.0).intValue();
    }

    public void setAsynchronousJobTimeout(int asynchronousJobTimeout) {
        this.properties.put(EVERREST_ASYNCHRONOUS_JOB_TIMEOUT, Integer.toString(asynchronousJobTimeout));
    }

    public int getMaxBufferSize() {
        return this.getNumberProperty(EVERREST_MAX_BUFFER_SIZE, 204800.0).intValue();
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.properties.put(EVERREST_MAX_BUFFER_SIZE, Integer.toString(maxBufferSize));
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String getProperty(String name, String def) {
        String value = this.getProperty(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    public boolean getBooleanProperty(String name, boolean def) {
        String str = this.getProperty(name);
        if (str != null) {
            return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "on".equalsIgnoreCase(str) || "1".equals(str);
        }
        return def;
    }

    public Double getNumberProperty(String name, double def) {
        String str = this.getProperty(name);
        if (str != null) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }
}

