/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import java.util.List;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.everrest.core.impl.header.HeaderHelper;

public class CookieHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<Cookie> {
    public Cookie fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        List<Cookie> l = HeaderHelper.parseCookies(header);
        if (l.size() > 0) {
            return l.get(0);
        }
        return null;
    }

    public String toString(Cookie cookie) {
        if (cookie == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("$Version=").append(cookie.getVersion()).append(';');
        sb.append(cookie.getName()).append('=').append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getValue()));
        if (cookie.getDomain() != null) {
            sb.append(';').append("$Domain=").append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getDomain()));
        }
        if (cookie.getPath() != null) {
            sb.append(';').append("$Path=").append(HeaderHelper.addQuotesIfHasWhitespace(cookie.getPath()));
        }
        return sb.toString();
    }
}

