/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.method;

import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.everrest.core.ApplicationContext;
import org.everrest.core.InitialProperties;
import org.everrest.core.Parameter;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.method.ParameterResolver;

public class ContextParameterResolver
extends ParameterResolver<Context> {
    ContextParameterResolver(Context contextParam) {
    }

    @Override
    public Object resolve(Parameter parameter, ApplicationContext context) throws Exception {
        Class<?> parameterClass = parameter.getParameterClass();
        if (parameterClass == HttpHeaders.class) {
            return context.getHttpHeaders();
        }
        if (parameterClass == SecurityContext.class) {
            return context.getSecurityContext();
        }
        if (parameterClass == Request.class) {
            return context.getRequest();
        }
        if (parameterClass == UriInfo.class) {
            return context.getUriInfo();
        }
        if (parameterClass == Providers.class) {
            return context.getProviders();
        }
        if (parameterClass == Application.class) {
            return context.getApplication();
        }
        if (parameterClass == InitialProperties.class) {
            return context.getInitialProperties();
        }
        return EnvironmentContext.getCurrent().get(parameter.getParameterClass());
    }
}

