/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.provider.IOHelper;
import org.everrest.core.provider.EntityProvider;

@Provider
public class ReaderEntityProvider
implements EntityProvider<Reader> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == Reader.class;
    }

    public Reader readFrom(Class<Reader> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String cs = mediaType != null ? (String)mediaType.getParameters().get("charset") : null;
        Charset charset = cs != null ? Charset.forName(cs) : IOHelper.DEFAULT_CHARSET;
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        if (context.isAsynchronous()) {
            int bufferSize = context.getEverrestConfiguration().getMaxBufferSize();
            return new InputStreamReader(IOHelper.bufferStream(entityStream, bufferSize), charset);
        }
        return new InputStreamReader(entityStream, charset);
    }

    public long getSize(Reader t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Reader.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Reader t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(entityStream);
        try {
            IOHelper.write(t, out);
        }
        finally {
            ((Writer)out).flush();
            t.close();
        }
    }
}

