/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.multipart;

import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.impl.MultivaluedMapImpl;

public class OutputItem {
    private final String name;
    private final Object entity;
    private final Class<?> type;
    private final Type genericType;
    private final MediaType mediaType;
    private final String filename;
    private final MultivaluedMap<String, String> headers;

    public static OutputItem create(String name, Object entity, Class<?> type, Type genericType, MediaType mediaType, String fileName) {
        return new OutputItem(name, entity, type, genericType, mediaType, fileName);
    }

    public static OutputItem create(String name, Object entity, Type genericType, MediaType mediaType, String fileName) {
        return new OutputItem(name, entity, entity.getClass(), genericType, mediaType, fileName);
    }

    public static OutputItem create(String name, Object entity, MediaType mediaType, String fileName) {
        return new OutputItem(name, entity, entity.getClass(), null, mediaType, fileName);
    }

    public static OutputItem create(String name, Object entity, MediaType mediaType) {
        return new OutputItem(name, entity, entity.getClass(), null, mediaType, null);
    }

    public OutputItem(String name, Object entity, Class<?> type, Type genericType, MediaType mediaType, String filename) {
        this.name = name;
        this.entity = entity;
        this.type = type;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.filename = filename;
        this.headers = new MultivaluedMapImpl();
    }

    public String getName() {
        return this.name;
    }

    public Object getEntity() {
        return this.entity;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getFilename() {
        return this.filename;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }
}

