/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.ExtMultivaluedMap;
import org.everrest.core.util.MediaTypeMap;

public class MediaTypeMultivaluedMap<V>
extends MediaTypeMap<List<V>>
implements ExtMultivaluedMap<MediaType, V> {
    private static final long serialVersionUID = 7082102018450744774L;

    @Override
    public List<V> getList(MediaType mediaType) {
        CopyOnWriteArrayList newList;
        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.get(mediaType);
        if (list == null && (list = (List)this.putIfAbsent(mediaType, newList = new CopyOnWriteArrayList())) == null) {
            list = newList;
        }
        return list;
    }

    public void add(MediaType mediaType, V value) {
        if (value == null) {
            return;
        }
        List<V> list = this.getList(mediaType);
        list.add(value);
    }

    public V getFirst(MediaType mime) {
        List list = (List)this.get(mime);
        return list != null && list.size() > 0 ? (V)list.get(0) : null;
    }

    public void addAll(MediaType key, V ... newValues) {
        if (newValues == null) {
            throw new NullPointerException("Null array of values isn't acceptable.");
        }
        if (newValues.length == 0) {
            return;
        }
        Collections.addAll(this.getList(key), newValues);
    }

    public void addAll(MediaType key, List<V> valueList) {
        if (valueList == null) {
            throw new NullPointerException("Null list of values isn't acceptable.");
        }
        if (valueList.isEmpty()) {
            return;
        }
        this.getList(key).addAll(valueList);
    }

    public void addFirst(MediaType key, V value) {
        this.getList(key).add(0, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<MediaType, V> otherMap) {
        Set otherKeys;
        if (this == otherMap) {
            return true;
        }
        Set myKeys = this.keySet();
        if (!myKeys.equals(otherKeys = otherMap.keySet())) {
            return false;
        }
        for (Map.Entry e : this.entrySet()) {
            List myValues = (List)e.getValue();
            List otherValues = (List)otherMap.get(e.getKey());
            if (myValues == null && otherValues == null) continue;
            if (myValues != null) {
                if (myValues.size() != otherValues.size()) {
                    return false;
                }
                for (Object value : myValues) {
                    if (otherValues.contains(value)) continue;
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public void putSingle(MediaType mediaType, V value) {
        if (value == null) {
            this.remove(mediaType);
            return;
        }
        List<V> list = this.getList(mediaType);
        list.clear();
        list.add(value);
    }
}

