/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.groovy.servlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.codehaus.groovy.control.CompilationFailedException;
import org.everrest.core.Filter;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.core.util.Logger;
import org.everrest.groovy.DefaultGroovyResourceLoader;
import org.everrest.groovy.GroovyClassLoaderProvider;
import org.everrest.groovy.ScriptFinder;
import org.everrest.groovy.ScriptFinderFactory;
import org.everrest.groovy.SourceFile;
import org.everrest.groovy.URLFilter;

public class GroovyEverrestServletContextInitializer
extends EverrestServletContextInitializer {
    public static final String EVERREST_GROOVY_ROOT_RESOURCES = "org.everrest.groovy.root.resources";
    public static final String EVERREST_GROOVY_APPLICATION = "org.everrest.groovy.Application";
    public static final String EVERREST_GROOVY_SCAN_COMPONENTS = "org.everrest.groovy.scan.components";
    private static final Logger LOG = Logger.getLogger(GroovyEverrestServletContextInitializer.class);
    protected GroovyClassLoaderProvider classLoaderProvider;
    protected final URL[] groovyClassPath;

    public GroovyEverrestServletContextInitializer(ServletContext sctx) {
        super(sctx);
        String inputRootResources = this.getParameter(EVERREST_GROOVY_ROOT_RESOURCES);
        LinkedHashSet<URL> rootResources = new LinkedHashSet<URL>();
        if (inputRootResources != null) {
            try {
                for (String s : inputRootResources.split(",")) {
                    rootResources.add(new URL(s.trim()));
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        this.groovyClassPath = rootResources.toArray(new URL[rootResources.size()]);
        this.classLoaderProvider = new GroovyClassLoaderProvider();
        try {
            this.classLoaderProvider.getGroovyClassLoader().setResourceLoader(new DefaultGroovyResourceLoader(this.groovyClassPath));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Application getApplication() {
        String groovyApplicationFQN = this.getParameter(EVERREST_GROOVY_APPLICATION);
        Application groovyApplication = null;
        boolean scan = false;
        String scanParameter = this.getParameter(EVERREST_GROOVY_SCAN_COMPONENTS);
        if (scanParameter != null) {
            scan = Boolean.parseBoolean(scanParameter);
        }
        if (groovyApplicationFQN != null) {
            if (scan) {
                String msg = "Scan of Groovy JAX-RS components is disabled cause to specified 'org.everrest.groovy.Application'.";
                LOG.warn(msg);
            }
            try {
                Class applicationClass = this.classLoaderProvider.getGroovyClassLoader().loadClass(groovyApplicationFQN, true, false);
                groovyApplication = (Application)applicationClass.newInstance();
            }
            catch (CompilationFailedException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (scan) {
            try {
                URLFilter filter = new URLFilter(){

                    @Override
                    public boolean accept(URL url) {
                        return url.getPath().endsWith(".groovy");
                    }
                };
                final HashSet<Class> scanned = new HashSet<Class>();
                Class[] jaxrsAnnotations = new Class[]{Path.class, Provider.class, Filter.class};
                for (URL path : this.groovyClassPath) {
                    String protocol = path.getProtocol();
                    ScriptFinder finder = ScriptFinderFactory.getScriptFinder(protocol);
                    if (finder != null) {
                        Set<URL> scripts = finder.find(filter, path);
                        if (scripts == null || scripts.size() <= 0) continue;
                        SourceFile[] files = new SourceFile[scripts.size()];
                        int i = 0;
                        for (URL script : scripts) {
                            files[i++] = new SourceFile(script);
                        }
                        Class[] classes = this.classLoaderProvider.getGroovyClassLoader().parseClasses(files);
                        for (int j = 0; j < classes.length; ++j) {
                            Class clazz = classes[j];
                            if (!this.findAnnotation(clazz, jaxrsAnnotations)) continue;
                            boolean added = scanned.add(clazz);
                            if (added) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("Add class : " + clazz);
                                continue;
                            }
                            LOG.warn("Skip duplicated class: " + clazz);
                        }
                        continue;
                    }
                    String msg = "Skip URL : " + path + ". Protocol '" + protocol + "' is not supported for scan JAX-RS components. ";
                    LOG.warn(msg);
                }
                groovyApplication = new Application(){

                    public Set<Class<?>> getClasses() {
                        return scanned;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return groovyApplication;
    }

    private boolean findAnnotation(Class<?> clazz, Class<? extends Annotation> ... annClasses) {
        for (Class<? extends Annotation> ac : annClasses) {
            if (clazz.getAnnotation(ac) == null) continue;
            return true;
        }
        return false;
    }
}

