/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.exoplatform;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.Application;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.ApplicationPublisher;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.FileCollector;
import org.everrest.core.impl.FileCollectorDestroyer;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.LifecycleComponent;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.async.AsynchronousProcessListWriter;
import org.everrest.core.impl.method.filter.SecurityConstraint;
import org.everrest.core.util.Logger;
import org.everrest.exoplatform.ApplicationConfiguration;
import org.everrest.exoplatform.EverrestConfigurationHelper;
import org.everrest.exoplatform.ExoApplicationPublisher;
import org.everrest.exoplatform.ExoAsynchronousJobPool;
import org.everrest.exoplatform.ProvidersRegistry;
import org.everrest.exoplatform.StartableApplication;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.picocontainer.Startable;

public class EverrestInitializer
implements Startable {
    private static final Logger LOG = Logger.getLogger(EverrestInitializer.class);
    private static final AtomicLong appNameCounter = new AtomicLong(1L);
    private final ExoContainer container;
    private final ResourceBinder resources;
    private final ProvidersRegistry providersRegistry;
    private final EverrestConfiguration config;
    private List<WeakReference<Object>> singletonsReferences;

    public EverrestInitializer(ExoContainerContext containerContext, ResourceBinder resources, ProvidersRegistry providersRegistry, StartableApplication eXo, InitParams initParams) {
        this.resources = resources;
        this.providersRegistry = providersRegistry;
        this.container = containerContext.getContainer();
        this.config = EverrestConfigurationHelper.createEverrestConfiguration(initParams);
    }

    public EverrestInitializer(ExoContainerContext containerContext, ResourceBinder resources, ProvidersRegistry providersRegistry, StartableApplication eXo) {
        this(containerContext, resources, providersRegistry, eXo, null);
    }

    public void start() {
        Application everrest = new Application(){
            private final Set<Class<?>> classes = new HashSet(1);
            private final Set<Object> singletons = new HashSet<Object>(3);

            public Set<Class<?>> getClasses() {
                return this.classes;
            }

            public Set<Object> getSingletons() {
                return this.singletons;
            }
        };
        if (this.config.isAsynchronousSupported()) {
            everrest.getSingletons().add(new ExoAsynchronousJobPool(this.config));
            everrest.getSingletons().add(new AsynchronousProcessListWriter());
            everrest.getClasses().add(AsynchronousJobService.class);
        }
        if (this.config.isCheckSecurity()) {
            everrest.getSingletons().add(new SecurityConstraint());
        }
        Set singletons = everrest.getSingletons();
        this.singletonsReferences = new ArrayList<WeakReference<Object>>(singletons.size());
        for (Object o : singletons) {
            this.singletonsReferences.add(new WeakReference(o));
        }
        new ApplicationPublisher(this.resources, ProviderBinder.getInstance()).publish(everrest);
        List allApps = this.container.getComponentInstancesOfType(Application.class);
        if (allApps != null && !allApps.isEmpty()) {
            for (Object o : allApps) {
                this.addApplication((Application)o);
            }
        }
    }

    public void stop() {
        this.makeFileCollectorDestroyer().stopFileCollector();
        if (this.singletonsReferences != null && this.singletonsReferences.size() > 0) {
            for (WeakReference<Object> ref : this.singletonsReferences) {
                Object o = ref.get();
                if (o == null) continue;
                try {
                    new LifecycleComponent(o).destroy();
                }
                catch (InternalException e) {
                    LOG.error("Unable to destroy component. ", (Throwable)e);
                }
            }
            this.singletonsReferences.clear();
        }
    }

    protected FileCollectorDestroyer makeFileCollectorDestroyer() {
        return new FileCollectorDestroyer(){

            public void stopFileCollector() {
                FileCollector fc = FileCollector.getInstance();
                fc.stop();
            }
        };
    }

    public void addApplication(Application application) {
        String applicationName = "application" + appNameCounter.getAndIncrement();
        ApplicationProviderBinder applicationProviders = new ApplicationProviderBinder();
        new ExoApplicationPublisher(this.resources, (ProviderBinder)applicationProviders).publish(new ApplicationConfiguration(applicationName, application));
        this.providersRegistry.addProviders(applicationName, (ProviderBinder)applicationProviders);
        if (LOG.isDebugEnabled()) {
            LOG.debug("JAX-RS Application " + applicationName + ", class: " + application.getClass().getName() + " registered. ");
        }
    }
}

